jQuery(document).ready(function(){	
function {{uc_id}}_start(){
		
  var objCarousel = jQuery('#{{uc_id}}');
  var objClonedItems;
  
  var itemHolderSelector = '.uc_image_carousel_container_holder';
  
  function equalizeContentHeight(){
  
  	var dataEqualHeight = objCarousel.data("equal-height");
    
    if(dataEqualHeight == false)
      return(false); 
    
    var objContents = objCarousel.find(".content-padding");
    
    if(!objContents)
      return(false);
    
    var maxHeight = 0;
    
    objContents.each(function(){
    
    	var objContent = jQuery(this);
      	var contentHeight = Math.round(objContent.outerHeight());
		
      	if(contentHeight > maxHeight)         
        	maxHeight = contentHeight;
    });    
    
    objContents.each(function(){
    
    	var objContent = jQuery(this);
      	objContent.css("min-height", maxHeight+"px");
    });
  }
  
  function initCarousel(){
        
    //cloned items fancybox fix
    var objItems = objCarousel.find(itemHolderSelector);
    var itemsNum = objItems.length;

    //set data index for each origin item
    for(let i=0; i<itemsNum; i++){

      var objItem = objItems.eq(i);

      objItem.attr('data-fancy-index', i);
    }
  
    objCarousel.owlCarousel({
                  loop: {{loop}},
                  rtl: {{rtl}},
                  center:{{center}},
                  autoplayTimeout : {{slide_duration}},
                  autoplayHoverPause:{{autoplayhoverpause}},
                  smartSpeed: {{transition_speed}}, 
                  changeItemOnClick:{{change_item_on_click}},
                  paddingType: '{{offset_type}}',
                  dots: {{show_dots}},
                  navText: ["<i class='{{left_arrow}}'></i>","<i class='{{right_arrow}}'></i>"],
                  nav: {{show_arrows}},
                  autoplay: {{autoplay}},
                  margin: {{margin_between_items}},                             
                  delayBeforeLoad: {{delay_before_load}},  
                  autoHeight: {{autoheight}},
                  mouseDrag:{{mouse_drag}},
                  touchDrag:{{touch_drag}}, 
                  responsive : {
                      0 : {
                          items:{{number_of_items_mobile}},

                          {% if offset_type != "none" %}
                          stagePadding: {{offset_number_mobile}},
                          {% endif %}
                          {% if center == "false" %}
                              dotsEach: {{show_dots_each_x_item_mobile}},
                          {% endif %}	  
                      },
                      768 : {
                          items:{{number_of_items_tablet}},

                          {% if offset_type != "none" %}
                          stagePadding: {{offset_number_tablet}},
                          {% endif %}
                          {% if center == "false" %}
                              dotsEach: {{show_dots_each_x_item_tablet}},
                          {% endif %}  
                      },
                      980 : {
                          items:{{number_of_items}},

                          {% if offset_type != "none" %}
                          stagePadding: {{offset_number}},
                          {% endif %}
                          {% if center == "false" %} 
                              dotsEach: {{show_dots_each_x_item}},
                          {% endif %}	   
                      } 
              }
      });
    
      //wait while carousel init
      setTimeout(function(){

        var useFancybox = objCarousel.data("lightbox");

        if(useFancybox == false)
        return(false);

        var imageLinkSelector = '.ue_img_link'; //link on image
        
        //init fancybox only on non cloned items
        var fancyLink = objCarousel.find(".owl-item:not(.cloned) "+imageLinkSelector);

        fancyLink.attr("data-fancybox", "gallery")

        fancyLink.fancybox({
            loop: true,
            arrows : true,
            backfocus: false
        });

        //for cloned items find origin items and trigger it
        objClonedItems = objCarousel.find(".owl-item.cloned");

        objClonedItems.on('click', function() {

          var objClonedItem = jQuery(this);
          var objClonedItemChild = objClonedItem.find(itemHolderSelector);
          var clickedDataFancyIndex = objClonedItemChild.data('fancy-index');
          var objOriginItem = objCarousel.find('.owl-item:not(.cloned) [data-fancy-index='+clickedDataFancyIndex+'] '+imageLinkSelector);
          var objOriginOwlItem = objOriginItem.parent('.owl-item');

          objOriginItem.trigger('click');

          //do nothing with clicked cloned item https://obu.edu/_resources/ldp/galleries/fancybox/
          return(true);

        });

      },300);    
      
    //equalize height of content if needed
    equalizeContentHeight();
  
  }
  
  initCarousel();
  
  objCarousel.on("uc_ajax_refreshed",function(){      
     	objCarousel.trigger('destroy.owl.carousel');      
        initCarousel();      
  });
  
  {{ucfunc("put_remote_parent_js","objCarousel")}}  

}if(jQuery("#{{uc_id}}").length) {{uc_id}}_start(); else
	jQuery( document ).on( 'elementor/popup/show', () => { if(jQuery("#{{uc_id}}").length) {{uc_id}}_start();});
});