<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\core\Schemes;

class TurioBlogWidget extends Widget_Base
{

	public function get_name()
	{
		return 'turio_blog';
	}

	public function get_title()
	{
		return esc_html__('TX Blog Style One', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-posts-grid';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'post_settings',
			[
				'label' => esc_html__('General', 'turio-core')
			]
		);
		$this->add_control(
			'turio_blog_style_one_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);
		$this->add_control(
			'turio_blog_pagination_switcher',
			[
				'label' => esc_html__( 'Pagination', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Enable', 'turio-core' ),
				'label_off' => esc_html__( 'Disable', 'turio-core' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		$this->add_control(
			'turio_blog_date_switcher',
			[
				'label' => esc_html__('Show Date', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_blog_one_icon_switcher',
			[
				'label' => esc_html__('Show Icon (Author & Comment)', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_blog_posts_per_page',
			[
				'label'       => esc_html__('Posts Per Page', 'turio-core'),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 3,
				'label_block' => true,
			]
		);
		$this->add_control(
			'turio_blog_orderby',
			[
				'label'   => esc_html__('Order By', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ID',
				'options' => [
					'ID'         => esc_html__('Post Id', 'turio-core'),
					'author'     => esc_html__('Post Author', 'turio-core'),
					'title'      => esc_html__('Title', 'turio-core'),
					'post_date'       => esc_html__('Date', 'turio-core'),
					'rand'       => esc_html__('Random', 'turio-core'),
					'menu_order' => esc_html__('Menu Order', 'turio-core'),
				],
			]
		);
		$this->add_control(
			'turio_blog_order',
			[
				'label'   => esc_html__('Order', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__('Ascending', 'turio-core'),
					'desc' => esc_html__('Descending', 'turio-core')
				],
				'default' => 'desc',
			]
		);

		$this->end_controls_section();
		// Start Blog One Box Deisgn Style
        $this->start_controls_section(
            'turio_blog_one_box_design_style',
            [
                'label'   		=> esc_html__('Box Setting','turio-core'),
                'tab'      		=> Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'turio_blog_one_box_design_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha' => 'background: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_blog_one_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .blog-card-alpha',
			]
		);
        
        $this->end_controls_section();
        // End Blog One Box Design Style

		/// Date Style
		$this->start_controls_section(
			'turio_blog_date_style',
			[
				'label' => esc_html__('Date', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_date_switcher' => 'yes'
				]

			]
		);
		$this->add_control(
			'turio_blog_date_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_date_typography',
				'selector' => '{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a',

			]
		);
		$this->add_control(
			'turio_blog_date_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a' => 'background: {{VALUE}};',
				],

			]
		);
		$this->add_control(
			'turio_blog_date_bg_hover_color',
			[
				'label'     => esc_html__('Background Hover Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a:hover' => 'background: {{VALUE}};',
				],

			]
		);
		$this->add_responsive_control(
			'turio_blog_date_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
            'turio_blog_date_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'turio_blog_date_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .blog-card-alpha .blog-thumb .blog-lavel a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		/// Blog Title Style
		$this->start_controls_section(
			'turio_blog_title_style',
			[
				'label' => esc_html__('Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-title a' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_title_typography',
				'selector' => '{{WRAPPER}} .blog-card-alpha .blog-content .blog-title a',

			]
		);
		$this->add_control(
			'turio_blog_title_hover_color',
			[
				'label'     => esc_html__('Hover Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-title a:hover' => 'color: {{VALUE}}',
				],
				'default' => '#54a15d',
			]
		);
		$this->add_responsive_control(
			'turio_blog_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
            'turio_blog_title_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-card-alpha .blog-content .blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
		/// Icon Style
		$this->start_controls_section(
			'turio_blog_icon_style',
			[
				'label' => esc_html__('Icon (Author & Comment)', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_one_icon_switcher' => 'yes'
				]

			]
		);

		$this->add_control(
			'turio_blog_icon_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-body-top a i' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);
		$this->end_controls_section();
		/// Author Name Style
		$this->start_controls_section(
			'turio_blog_author_name_style',
			[
				'label' => esc_html__('Author Name', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_author_name_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-body-top a.blog-writer' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_author_name_typography',
				'selector' => '{{WRAPPER}} .blog-card-alpha .blog-content .blog-body-top a.blog-writer',

			]
		);

		$this->end_controls_section();

		/// Comment Style
		$this->start_controls_section(
			'turio_blog_comment_style',
			[
				'label' => esc_html__('Comment', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_comment_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-alpha .blog-content .blog-body-top a.blog-comments' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_comment_typography',
				'selector' => '{{WRAPPER}} .blog-card-alpha .blog-content .blog-body-top a.blog-comments',

			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		$query = new \WP_Query(
			array(
				'post_type'      => 'post',
				'posts_per_page' => $settings['turio_blog_posts_per_page'],
				'orderby'        => $settings['turio_blog_orderby'],
				'order'          => $settings['turio_blog_order'],
				'paged' 		 => ( get_query_var('paged')) ? get_query_var('paged') : 1,
				'offset'         => 0,
				'post_status'    => 'publish'
			)
		);


?>

		<div class="blog-area blog-style-one">
			<div class="container">
				<div class="row g-4">
					<?php
					if (!empty($query->have_posts())) :
						$num = 0;
						while ($query->have_posts()) :
						$num++;
							$query->the_post();
					?>
							<?php if( $settings['turio_blog_style_one_column_section'] == 'column_two' ) : ?>
								<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
							<?php elseif ($settings['turio_blog_style_one_column_section'] == 'column_three') : ?>
								<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
							<?php elseif ($settings['turio_blog_style_one_column_section'] == 'column_four') : ?>
								<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
							<?php endif ?>
								<div class="blog-card-alpha wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
									<div class="blog-thumb">
										<?php if (has_post_thumbnail()) { ?>
											<a href="<?php the_permalink(); ?>">
												<?php the_post_thumbnail(); ?>
											</a>
										<?php
										}
										if ('yes' == $settings['turio_blog_date_switcher']) {
										?>
											<div class="blog-lavel">
												<a href="<?php echo get_day_link(get_post_time('Y'), get_post_time('m'), get_post_time('j')); ?>"><i class="bi bi-calendar3"></i><?php echo get_the_date(); ?></a>
											</div>
										<?php
										}
										?>

									</div>
									<div class="blog-content">
										<div class="blog-body-top">
											<a href="#" class="blog-writer"><?php if ('yes' == $settings['turio_blog_one_icon_switcher']) { echo '<i class="bi bi-person-circle"></i> ';} ?> <?php _e('By ', 'turio-core'); ?><?php echo get_the_author(); ?> </a>
											<a href="#" class="blog-comments"><?php if ('yes' == $settings['turio_blog_one_icon_switcher']) { echo '<i class="bi bi-chat-dots-fill"></i>';} ?> <?php echo wp_kses_post('(' . get_comments_number() . ')' . ' ' . 'Comment'); ?></a>
										</div>
										<h4 class="blog-title">
											<a href="<?php the_permalink(); ?>">
												<?php echo esc_html__(substr(get_the_title(), '0', '55'), 'turio-core'); ?>
											</a>
										</h4>
									</div>
								</div>
							</div>

					<?php
						endwhile;
						wp_reset_postdata();
					endif;
					?>

				</div>
				<?php if($settings['turio_blog_pagination_switcher'] === 'yes'):?>
					<div class="row">
						<div class="col-lg-12">
							<nav class="pagination pagination-wrap justify-content-center pt-80">
								<?php turio_core()->egns_blog_pagination() ?>
							</nav>
						</div>
                    </div>
				<?php endif;?>
			</div>
		</div>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new TurioBlogWidget());
