<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class turio_contact_details extends Widget_Base
{

    public function get_name()
    {
        return 'turio_contact_details';
    }

    public function get_title()
    {
        return esc_html__('Contact Details', 'turio-core');
    }

    public function get_icon()
    {
        return 'eicon-info-circle-o';
    }

    public function get_categories()
    {
        return ['turio_widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'about_us_left_side_content_section',
            [
                'label' => __('General', 'turio-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'turio_contact_details_left_image',
            [
                'label' => __('Image', 'turio-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
            ]
        );


        $this->end_controls_section();


        /* Right side controls section start here */
        $this->start_controls_section(
            'right_side_content_section',
            [
                'label' => esc_html__('Content', 'turio-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'turio_contact_details_main_title',
            [
                'label'       => esc_html__('Title', 'turio-core'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Contact Info.', 'turio-core'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //start section
        $this->start_controls_section(
            'turio_contact_details_item_genaral_section',
            [
                'label' => esc_html__('Item Section', 'turio-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'turio_contact_details_item_text',
            [
                'label' => esc_html__('Item Title', 'turio-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Loacation.', 'turio-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'turio_contact_details_item_text_description',
            [
                'label' => esc_html__('Item Description', 'turio-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('<a href="#">168/170, Ave 01, Streets Suite 666 Mirpur DOHS, Bangladesh</a>', 'turio-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'turio_contact_details_icon_box',
            [
                'label' => __('Icon Boxes', 'turio-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default'    => [
                    [
                        'turio_contact_details_item_text'          => esc_html__('Let\'s Talk', 'turio-core'),
                        'turio_contact_details_icon_box_default_active' => 'yes'
                    ],
                    ['turio_contact_details_item_text' => esc_html__('Loacation.', 'turio-core')],
                    ['turio_contact_details_item_text' => esc_html__('Visit Us.', 'turio-core')]
                ],
                'title_field' => '{{turio_contact_details_item_text}}',
            ]
        );
        $this->end_controls_section();
        // End section


        /**
         * =================================
         * Style Tabs are Start here
         * =================================
         */



        $this->start_controls_section(
            'turio_contact_details_topper_main_title',
            [
                'label' => esc_html__('Title', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'turio_contact_details_topper_main_title_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#262626',
                'selectors' => [
                    '{{WRAPPER}} .contact-info h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_contact_details_topper_main_title_typography',
                'selector' => '{{WRAPPER}} .contact-info h3',

            ]
        );
        $this->end_controls_section();

        // Item Title

        $this->start_controls_section(
            'turio_contact_details_item_title',
            [
                'label' => esc_html__('Item Title', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'turio_contact_details_item_title_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#262626',
                'selectors' => [
                    '{{WRAPPER}} .contact-info ul li h6' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_contact_details_item_title_typography',
                'selector' => '{{WRAPPER}} .contact-info ul li h6',

            ]
        );
        $this->end_controls_section();

        // Item Description

        $this->start_controls_section(
            'turio_contact_details_topper_description',
            [
                'label' => esc_html__('Item Description', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'turio_contact_details_topper_description_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#999999',
                'selectors' => [
                    '{{WRAPPER}} .contact-info ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_contact_details_topper_description_typography',
                'selector' => '{{WRAPPER}} .contact-info ul li a',

            ]
        );
        $this->end_controls_section();






    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <div class="contact-wrapper wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="200ms">
            <div class="container">
                <div class="row align-items-center justify-content-lg-center gy-5">
                    <div class="col-lg-6">
                        <div class="contatc-intro-figure">
                            <img src="<?php echo esc_url($settings['turio_contact_details_left_image']['url']) ?>" alt="<?php esc_attr_e($settings['turio_contact_details_left_image']['alt']) ?>" class="img-fluid">
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="contact-info">
                            <h3>
                            <?php
                                if (!empty($settings['turio_contact_details_main_title'])) {
                                    echo $settings['turio_contact_details_main_title'];
                                }
                            ?>
                            </h3>
                            <ul>
                            <?php
                                    if ( $settings['turio_contact_details_icon_box'] ) :
                                        foreach ( $settings['turio_contact_details_icon_box'] as $item ) :
                                        
                                    ?>

                                <li>
                                    <h6>
                                    <?php
                                        if ( ! empty( $item['turio_contact_details_item_text'] ) ) {
                                            echo $item['turio_contact_details_item_text'];
                                        }
                                    ?>
                                    </h6>
                                    <?php
                                        if ( ! empty($item['turio_contact_details_item_text_description'] ) ) {
                                            echo $item['turio_contact_details_item_text_description'];
                                        }
                                    ?>

                                </li>
                                <?php
                                        endforeach;
                                    endif;
                                    ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new turio_contact_details());
