<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Destination_With_Slider_One extends Widget_Base {

	public function get_name() {
		return 'turio_destination_with_slider_one';
	}

	public function get_title() {
		return esc_html__( 'TX Destination With Slider One', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
        // Destination Header Section Start
		$this->start_controls_section(
			'turio_destination_with_slider_header_setting',
			[
				'label' 		=> esc_html__('Header Settings','turio-core'),
				'tab' 			=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		// Start Header Section Switcher Option
		$this->add_control(
			'turio_destination_with_slider_title_switcher',
			[
				'label' 		=> esc_html__( 'Show Heading Title', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_destination_with_slider_description_switcher',
			[
				'label' 		=> esc_html__( 'Show Heading Description', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		
		$this->add_control(
			'turio_destination_with_slider_navigation_switcher',
			[
				'label' 		=> esc_html__( 'Show Navigation (prev/next)', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		// End Header Section Switcher Option
		$this->add_control(
            'turio_destination_with_slider_title',
            [
                'label' 		=> esc_html__( 'Heading Title', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> esc_html__( 'Explore Top Destination', 'turio-core' ),
                'label_block' 	=> true,
         
        	]
        );
		$this->add_control(
            'turio_destination_with_slider_description',
            [
                'label' 		=> esc_html__( 'Heading Description', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default' 		=> esc_html__( 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consectetur.', 'turio-core' ),
                'label_block' 	=> true,
            ]
        );
       
		$this->end_controls_section();
        // Start Package Header Section Control
		$this->start_controls_section(
			'section_turio_destination_with_slider',
			[
				'label' 		=> esc_html__('Destination','turio-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
        // Start Package Destination Control
        $this->add_control(
			'turio_destination_with_slider',
			[
				'label' 		=> __('Destination', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => turio_core()->get_terms_names('turio-package-destination', 'id'),
				'default'       => turio_core()->get_all_terms_names('turio-package-destination','id'),
			]
		);
		$this->add_control(
			'turio_destination_with_slider_order_by',
			[
				'label'   		=> esc_html__('Order By', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'turio-core'),
					'name'    	=> esc_html__('Name', 'turio-core'),
					'include'  	=> esc_html__('Include', 'turio-core'),
				],
			]
		);
		// Start Turio Package Destination Order
		$this->add_control(
			'turio_destination_with_slider_order',
			[
				'label'   		=> esc_html__('Order', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'turio-core'),
					'desc' 		=> esc_html__('Descending', 'turio-core')
				],
				'default' 		=> 'desc',
			]
		);
		$this->add_control(
			'turio_destination_with_slider_limit',
			[
				'label'   		=> esc_html__('Destination Count', 'turio-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> '8',
			]
		);
        $this->end_controls_section();
        // End Destination Content Control Section
		// Start Box Style Control Section
		$this->start_controls_section(
			'turio_destination_with_slider_box_style',
			[
				'label'   	    => esc_html__('Box Setting','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_destination_with_slider_box_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .destination-card-style-one' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Box Style Control Section
        // Start Heading Title Style
		$this->start_controls_section(
			'turio_destination_with_slider_heading_title_style',
			[
				'label'  		=> esc_html__('Heading Title','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
                'condition'		=> [
					'turio_destination_with_slider_title_switcher' => 'yes'
                ],
			]
		);
		$this->add_control(
			'turio_destination_with_slider_heading_title_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .section-head-alpha h2' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_destination_with_slider_heading_title_typography',
				'selector' 		=> '{{WRAPPER}} .section-head-alpha h2'
			]
		);
        $this->add_responsive_control(
			'turio_destination_with_slider_heading_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .section-head-alpha h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_responsive_control(
            'turio_destination_with_slider_heading_title_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .section-head-alpha h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
        // Start Heading Description Style
		$this->start_controls_section(
			'turio_destination_with_slider_heading_description_style',
			[
				'label'  		=> esc_html__('Heading Description','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
                'condition'		=> [
					'turio_destination_with_slider_description_switcher' => 'yes'
                ],
			]
		);
		$this->add_control(
			'turio_destination_with_slider_heading_description_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .section-head-alpha p' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_destination_with_slider_heading_description_typography',
				'selector' 		=> '{{WRAPPER}} .section-head-alpha p'
			]
		);
        $this->add_responsive_control(
			'turio_destination_with_slider_heading_description_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .section-head-alpha p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_responsive_control(
            'turio_destination_with_slider_heading_description_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .section-head-alpha p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
        // Start Navigation Icon Style
		$this->start_controls_section(
			'turio_destination_with_slider_navigation_style',
			[
				'label'  		=> esc_html__('Navigation (prev/next)','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_destination_with_slider_navigation_switcher' => 'yes'
                ],
			]
		);
        $this->add_control(
            'turio_destination_with_slider_navigation_color',
            [
                'label'     	=> esc_html__('Icon Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'default'   	=> '',
                'selectors' 	=> [
                    '{{WRAPPER}} .destination-style-one .custom-swiper-prev i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .destination-style-one .custom-swiper-next i' => 'color: {{VALUE}};',

                ],
            ]
        );
		$this->add_control(
			'turio_destination_with_slider_navigation_border_color',
			[
				'label' => esc_html__( 'Border Color', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .destination-style-one .custom-swiper-prev' => 'border:1px solid {{VALUE}}',
					'{{WRAPPER}} .destination-style-one .custom-swiper-next' => 'border:1px solid {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		// Start Destination Name Style
		$this->start_controls_section(
			'turio_destination_with_slider_name_style',
			[
				'label'  		=> esc_html__('Destination Name','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_destination_with_slider_name_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-one .d-card-content .destination-title' => 'color : {{VALUE}}',				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_destination_with_slider_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-one .d-card-content .destination-title'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Style
		$this->start_controls_section(
			'turio_destination_with_slider_place_count_style',
			[
				'label'  		=> esc_html__('Place Count','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_destination_with_slider_place_count_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-one .d-card-content .place-count' => 'color : {{VALUE}}',
				],	
			]
		);
		$this->add_control(
			'turio_package_destination_place_count_style_one_border_color',
			[
				'label'  		=> esc_html__('Hover Color (Border)','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-one .d-card-content .destination-title::before' => 'background : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_destination_with_slider_place_count_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-one .d-card-content .place-count'
			]
		);
		$this->end_controls_section();
		// End Package Destination Place Style
        
    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        if (is_admin()) {
			?>
			<script>
		    (function ($) {
				var destinationSliderOne = new Swiper('.destination-slider-one', {
                    slidesPerView: 1,
                    speed: 1000,
                    spaceBetween: 24,
                    loop: true,
                    roundLengths: true,
                    centeredSlides : true,
                    autoplay: {
                    delay: 15000
                    },
                    navigation: {
                    nextEl: '.designation-next',
                    prevEl: '.designation-prev',
                    },
                    breakpoints: {
                    480:{
                        slidesPerView: 2
                    },
                    768:{
                        slidesPerView: 3
                    },
                    992:{ 
                        slidesPerView: 4
                    },
                    1200:{
                        slidesPerView: 5
                    },
                    
                    }
                });
		    })(jQuery);
			</script>
		<?php
		} 

		$destinations = get_terms( array(
                'taxonomy'   	=> 'turio-package-destination',
                'include'    	=> $settings['turio_destination_with_slider'],
                'orderby'    	=> $settings['turio_destination_with_slider_order_by'],
                'order'      	=> $settings['turio_destination_with_slider_order'],
                'number'      	=> $settings['turio_destination_with_slider_limit'],
            ) );
		?>
            <div class="destination-area destination-style-one ">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-8">
                            <div class="section-head-alpha">
                            <?php if (!empty($settings['turio_destination_with_slider_title']) && $settings['turio_destination_with_slider_title_switcher'] == 'yes'): ?>
                                <h2><?php echo esc_html($settings['turio_destination_with_slider_title']) ?></h2>
                            <?php endif ?>
                            <?php if (!empty($settings['turio_destination_with_slider_description']) && $settings['turio_destination_with_slider_description_switcher'] == 'yes'): ?>
                                <p><?php echo esc_html($settings['turio_destination_with_slider_description']) ?></p>
                            <?php endif ?>
                            </div>
                        </div>
                        <?php if (!empty($settings['turio_destination_with_slider_navigation_switcher']) && $settings['turio_destination_with_slider_navigation_switcher'] == 'yes'): ?>
                            <div class="col-lg-4">
                                <div class="slider-arrows text-center d-lg-flex d-none justify-content-end mb-3">
                                    <div class="designation-next custom-swiper-prev" tabindex="0" role="button" aria-label="Previous slide"> <i class="bi bi-chevron-left"></i> </div>
                                    <div class="designation-prev custom-swiper-next" tabindex="0" role="button" aria-label="Next slide"><i class="bi bi-chevron-right"></i></div>
                                </div>
                            </div>
                        <?php endif ?>
                    </div>
                </div>

                <div class="container-fluid p-0 overflow-hidden">
                    <div class="swiper destination-slider-one">
                        <div class="swiper-wrapper">
                            <?php
                                $num = 0;
                                foreach($destinations as $destination) :
                                $num++;		
                            ?>
                            <?php $destination_image = get_term_meta( $destination->term_id, 'turio_destination_image_options', true ); ?>
                                <div class="swiper-slide">
									<div class="destination-card-style-one wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
										<?php if (!empty($destination_image)): ?>
											<div class="d-card-thumb">
												<a href="<?php echo esc_url( get_term_link( $destination ) ) ?>">
													<img src="<?php echo $destination_image['destination_image']['url'] ?>" alt="<?php echo $destination_image['destination_image']['alt']; ?>">
												</a>
											</div>
										<?php endif ?>
										<div class="d-card-content">
											<?php if(!empty($destination->name)) : ?>
												<h4 class="destination-title">
													<a href="<?php echo esc_url( get_term_link( $destination ) ) ?>"><?php echo $destination->name ?></a>
												</h4>
											<?php endif ?>
											<?php if (!empty($destination->count)): ?>
												<div class="place-count">
													<span><?php echo $destination->count; ?></span> <?php esc_html_e('Place','turio-core') ?>
												</div>
											<?php endif ?>
										</div>
									</div>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>

                </div>
            </div>
	<?php
    }
}

Plugin::instance()->widgets_manager->register( new Turio_Destination_With_Slider_One() );
