<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Offer_Tour_Package extends Widget_Base
{

	public function get_name()
	{
		return 'turio_offer_tour_package';
	}

	public function get_title()
	{
		return esc_html__('TX Offer Package', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-image-box';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{
		// Start Package General Section Control
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__('General', 'turio-core')
			]
		);
		$this->add_control(
			'turio_offer_tour_package_style_select',
			[
				'label'     => esc_html__('Select Style', 'turio-core'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'style_one',
				'options'   => [
					'style_one'      => esc_html__('Style One', 'turio-core'),
					'style_two'      => esc_html__('Style Two', 'turio-core'),
				],
			]
		);
		$this->add_control(
			'turio_offer_tour_package_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);
		$this->add_control(
			'turio_offer_tour_package_duration_switcher',
			[
				'label' 		=> esc_html__('Show Duration', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('Enable', 'turio-core'),
				'label_off'     => esc_html__('Disable', 'turio-core'),
				'return_value'  => 'yes',
				'default'    	=> 'yes',
			]
		);
		$this->add_control(
			'turio_offer_tour_package_duration_icon_switcher',
			[
				'label' 		=> esc_html__('Show Duration Icon', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on'	 	=> esc_html__('Enable', 'turio-core'),
				'label_off' 	=> esc_html__('Disable', 'turio-core'),
				'return_value'  => 'yes',
				'default' 		=> 'yes',
				'condition'		=> [
					'turio_offer_tour_package_duration_switcher' 	=> 'yes'
				]
			]
		);
		$this->add_control(
			'turio_offer_tour_package_button_icon_switcher',
			[
				'label' 		=> esc_html__('Show Button Arrow Icon', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('Enable', 'turio-core'),
				'label_off' 	=> esc_html__('Disable', 'turio-core'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_offer_tour_package_button_text',
			[
				'label'  		=> esc_html__('Button Text', 'turio-core'),
				'type'    		=> Controls_Manager::TEXT,
				'default' 		=> esc_html__('Book Now', 'turio-core'),
				'label_block' 	=> true,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'turio_discount_item_price',
			[
				'label'       => esc_html__('Social', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('10%', 'turio-core'),
				'label_block' => true,
			]
		);

		// Start Package Destination Control
		$repeater->add_control(
			'turio_packages',
			[
				'label' => __('Select Tour', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => turio_core()->get_post_list_by_post_type('turio-package'),
				'default'     => turio_core()->get_all_post_key('turio-package'),
			]
		);
		$this->add_control(
			'turio_package_post_per_page',
			[
				'label'  			=> esc_html__('Post Per Page', 'turio-core'),
				'type'    			=> Controls_Manager::NUMBER,
				'default' 			=> 6,
				'label_block' 		=> false,
			]
		);
		// Start Package Order By
		$repeater->add_control(
			'turio_package_order_by',
			[
				'label'   => esc_html__('Order By', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'ID'         => esc_html__('Post Id', 'turio-core'),
					'author'     => esc_html__('Post Author', 'turio-core'),
					'title'      => esc_html__('Title', 'turio-core'),
					'date'       => esc_html__('Date', 'turio-core'),
					'rand'       => esc_html__('Random', 'turio-core'),
					'menu_order' => esc_html__('Menu Order', 'turio-core'),
				],
			]
		);

		// Start Package Order
		$repeater->add_control(
			'turio_package_order',
			[
				'label'   => esc_html__('Order', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__('Ascending', 'turio-core'),
					'desc' => esc_html__('Descending', 'turio-core')
				],
				'default' => 'desc',
			]
		);
		$this->end_controls_section();
		// Start Item 
		$this->start_controls_section(
			'turio_package_by_descount_item',
			[
				'label'   => esc_html__('Discounts', 'turio-core'),
				'tab'     => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_discount_item',
			[
				'label'   => esc_html__('Discounts List', 'turio-core'),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'turio_discount_item_price'   => esc_html__('10%', 'turio-core'),
					],
					[
						'turio_discount_item_price'   => esc_html__('20%', 'turio-core'),
					],
					[
						'turio_discount_item_price'   => esc_html__('30%', 'turio-core'),
					],
				],
				'title_field' => '{{{ turio_discount_item_price }}}',
			]
		);

		$this->end_controls_section();
		// End General Control Section

		/// Nav Style
		$this->start_controls_section(
			'turio_package_nav_style',
			[
				'label' => esc_html__('Discounts', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);


		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__('Normal', 'turio-core'),
			]
		);
		$this->add_control(
			'turio_package_nav_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link' => 'color: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_package_nav_typography',
				'selector' => '{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link,.offer-switch-button3 .nav-item .nav-link',

			]
		);

		$this->add_control(
			'turio_package_nav_border_color',
			[
				'label'     => esc_html__('Border Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'turio_package_nav_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link' => 'background: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link' => 'background: {{VALUE}};',
				],

			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_active_tab',
			[
				'label' => esc_html__('Active', 'turio-core'),
			]
		);
		$this->add_control(
			'turio_package_nav_active_font_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link.active' => 'color: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link.active' => 'color: {{VALUE}};',
				],

			]
		);

		$this->add_control(
			'turio_package_nav_active_border_color',
			[
				'label'     => esc_html__('Border color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link.active' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link.active' => 'border-color: {{VALUE}};',
				],

			]
		);
		$this->add_control(
			'turio_package_nav_active_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .offer-switch-button2 .nav-item .nav-link.active' => 'background: {{VALUE}};',
					'{{WRAPPER}} .offer-switch-button3 .nav-item .nav-link.active' => 'background: {{VALUE}};',
				],

			]
		);


		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		// Start Package Box Deisgn Style
		$this->start_controls_section(
			'turio_package_box_design_style',
			[
				'label'   => esc_html__('Box Setting', 'turio-core'),
				'tab'      => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_package_box_design_border_radius_style',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-area .package-card-beta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .package-area .package-card-delta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'turio_package_box_design_box_shadow_style',
				'label' => esc_html__('Box Shadow', 'turio-core'),
				'selector' => '{{WRAPPER}} .package-area .package-card-beta,.package-area .package-card-delta',
			]
		);

		$this->end_controls_section();
		// End Package Box Design Style
		// Start Package Main Title Style

		$this->start_controls_section(
			'turio_package_main_title_style',
			[
				'label' => esc_html__('Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_package_main_title_style_typography',
				'selector' => '{{WRAPPER}} .package-area .package-card-body h3',

			]
		);

		$this->add_control(
			'turio_package_main_title_style_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'turio_offer_package_title_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .package-area .package-card-body h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
			'turio_offer_package_title_padding',
			[
				'label'        => __('Padding', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .package-area .package-card-body h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();
		//
		// Start Package Duration Style
		$this->start_controls_section(
			'turio_package_duration_style',
			[
				'label' 	=> esc_html__('Duration', 'turio-core'),
				'tab'  		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'turio_offer_tour_package_duration_switcher' 	=> 'yes',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_package_duration_text_style',
				'selector' => '{{WRAPPER}} .package-area .package-thumb p',

			]
		);
		$this->add_control(
			'turio_package_duration_text_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-thumb p' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'turio_package_duration_text_hover_color',
			[
				'label'     => esc_html__('Hover Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-thumb p:hover' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'turio_package_duration_background_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-card-beta .package-thumb .card-lavel' => 'background: {{VALUE}};',
					'{{WRAPPER}} .package-card-delta .package-thumb .card-lavel' => 'background: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'turio_package_duration_background_hover_color',
			[
				'label'     => esc_html__('Hover Background', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-card-beta .package-thumb .card-lavel:hover' => 'background: {{VALUE}};',
					'{{WRAPPER}} .package-card-delta .package-thumb .card-lavel:hover' => 'background: {{VALUE}};',
				]
			]
		);

		$this->add_responsive_control(
			'turio_offer_package_duration_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .package-card-beta .package-thumb .card-lavel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .package-card-delta .package-thumb .card-lavel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
			'turio_offer_package_duration_padding',
			[
				'label'        => __('Padding', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .package-card-beta .package-thumb .card-lavel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .package-card-delta .package-thumb .card-lavel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();
		// End Package Duration Style
		// Start Package Button Setting
		$this->start_controls_section(
			'turio_package_button_style',
			[
				'label'   => esc_html__('Button', 'turio-core'),
				'tab'     => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_responsive_control(
			'turio_package_button_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_package_button_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_one_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_one_border_typhography',
				'label' => __('Border', 'turio-core'),
				'selector' => '{{WRAPPER}} .package-area .package-card-body .book-btn a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'turio_package_button_typography',
				'selector' => '{{WRAPPER}} .package-area .package-card-body .book-btn a',

			]
		);

		$this->add_responsive_control(
			'turio_package_button_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'turio_package_button_hover_typography',
				'selector' => '{{WRAPPER}} .package-area .package-card-body .book-btn a:hover',

			]
		);

		$this->add_responsive_control(
			'turio_package_button_hover_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		// End Package Button Style

		// Start Package Price Style
		$this->start_controls_section(
			'turio_package_price',
			[
				'label' => esc_html__('Price', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_price_style_color',
			[
				'label'  => esc_html__('Color', 'turio-core'),
				'type'   => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .p-card-info h6' => 'color : {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'turio_package_price_style_typography',
				'selector' => '{{WRAPPER}} .package-area .package-card-body .p-card-info h6',

			]
		);

		$this->end_controls_section();
		// End Package Price Style
		// Start Price Type Style
		$this->start_controls_section(
			'turio_package_price_type',
			[
				'label'   => esc_html__('Price Type'),
				'tab'     => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_price_type_style',
			[
				'label'   => esc_html__('Color', 'turio-core'),
				'type'    => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .package-area .package-card-body .p-card-info span' => 'color : {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'turio_package_price_type_style_typography',
				'selector' => '{{WRAPPER}} .package-area .package-card-body .p-card-info span',

			]
		);
		$this->end_controls_section();
		// End Price Type Style
	}
	protected function render()
	{

		$settings = $this->get_settings_for_display();
?>
		<div class="package-area offer-package-style-one">
			<div class="row align-items-center">
				<div class="offer-switch-button<?php echo $settings['turio_offer_tour_package_style_select'] == 'style_one' ? '2' : '3'; ?>">
					<ul class="nav nav-pills mb-3 justify-content-center gap-sm-4 gap-3" id="pills-tab" role="tablist">
						<?php
						$i = 0;
						if ($settings['turio_discount_item']) :
							foreach ($settings['turio_discount_item'] as $item) :
								$i++;
						?>

								<li class="nav-item" role="presentation">
									<button class="nav-link <?php echo $i == 1 ? 'active' : '' ?>" id="pills-offer<?php echo $i; ?>" data-bs-toggle="pill" data-bs-target="#pills-offer-tab<?php echo $i; ?>" type="button" role="tab" aria-controls="pills-offer-tab<?php echo $i; ?>" aria-selected="<?php echo $i == 1 ? 'true' : 'false' ?>">
										<?php
										if (!empty($item['turio_discount_item_price'])) {
											echo $item['turio_discount_item_price'];
										}
										?>
									</button>
								</li>
						<?php
							endforeach;
						endif;
						?>
					</ul>
				</div>

				<div class="offer-single-tabs">
					<div class="tab-content" id="pills-tabContent">
						<?php
						$i = 0;
						if ($settings['turio_discount_item']) :
							foreach ($settings['turio_discount_item'] as $item) :
								$i++;
						?>
								<div class="tab-pane fade <?php echo $i == 1 ? 'show active' : '' ?>" id="pills-offer-tab<?php echo $i; ?>" role="tabpanel" aria-labelledby="pills-offer<?php echo $i; ?>">
									<div class="row g-4">
										<?php
										$args = array(
											'post_type'      => 'turio-package',
											'orderby'        => $item['turio_package_order_by'],
											'order'          => $item['turio_package_order'],
											'post_status'    => 'publish',
											'post__in' 		 => $item['turio_packages'],
											'posts_per_page' => $settings['turio_package_post_per_page'],
										);

										$packageQuery = new \WP_Query($args);

										if ($packageQuery->have_posts()) :
											$num = 0;
											while ($packageQuery->have_posts()) :
												$num++;
												$packageQuery->the_post();
												$package_info = get_post_meta(get_the_ID(), 'turio_turio_package_info_options', true);
										?>
												<?php if ($settings['turio_offer_tour_package_column_section'] == 'column_two') : ?>
													<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10 fadeffect">
													<?php elseif ($settings['turio_offer_tour_package_column_section'] == 'column_three') : ?>
														<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10 fadeffect">
														<?php elseif ($settings['turio_offer_tour_package_column_section'] == 'column_four') : ?>
															<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10 fadeffect">
															<?php endif ?>
															<div class="package-card-<?php echo $settings['turio_offer_tour_package_style_select'] == 'style_one' ? 'beta' : 'delta'; ?> wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num + 1) * 2 ?>00ms">
																<div class="package-thumb">
																	<a href="<?php the_permalink(); ?>">
																		<?php if (has_post_thumbnail()) : ?>
																			<?php the_post_thumbnail(); ?>
																		<?php endif; ?>
																	</a>
																	<?php if (!empty($settings['turio_offer_tour_package_duration_switcher']) && $settings['turio_offer_tour_package_duration_switcher'] == 'yes') : ?>
																		<p class="card-lavel">
																			<?php if (!empty($settings['turio_offer_tour_package_duration_icon_switcher']) && $settings['turio_offer_tour_package_duration_icon_switcher'] == 'yes') : ?>
																				<i class="bi bi-clock"></i>
																			<?php endif ?>
																			<?php if (!empty($package_info['tp_duration'])) : ?>
																				<span><?php esc_html_e($package_info['tp_duration'], 'turio-core'); ?></span>
																			<?php endif ?>
																		</p>
																	<?php endif ?>
																</div>
																<div class="package-card-body <?php if (!($settings['turio_offer_tour_package_duration_switcher'] == 'yes')) {
																									echo 'pt-2';
																								} ?>">
																	<?php if (!empty(get_the_title())) : ?>
																		<h3 class="p-card-title">
																			<a href="<?php the_permalink(); ?>">
																				<?php echo esc_html__(substr(get_the_title(), '0', '55'), 'turio-core'); ?>
																			</a>
																		</h3>
																	<?php endif ?>
																	<div class="p-card-bottom">
																		<?php if (!empty($settings['turio_offer_tour_package_button_text'])) : ?>
																			<div class="book-btn">
																				<a href="<?php the_permalink(); ?>">
																					<?php if (!empty($settings['turio_offer_tour_package_button_text'])) : ?>
																						<?php esc_html_e($settings['turio_offer_tour_package_button_text'], 'turio-core'); ?>
																					<?php endif ?>
																					<?php if (!empty($settings['turio_offer_tour_package_button_icon_switcher']) && $settings['turio_offer_tour_package_button_icon_switcher'] == 'yes') : ?>
																						<i class='bx bxs-right-arrow-alt'></i>
																					<?php endif ?>
																				</a>
																			</div>
																		<?php endif ?>
																		<div class="p-card-info">
																			<?php if (!empty($package_info['tp_range_price'])) : ?>
																				<span><?php esc_html_e($package_info['tp_range_price'], 'turio-core'); ?></span>
																			<?php endif ?>
																			<h6>
																				<?php
																					if( function_exists('turio_get_package_price')) {
																						turio_get_package_price();
																					}
																				?>
																				<?php if (!empty($package_info['tp_price_type'])) : ?>
																					<span><?php esc_html_e($package_info['tp_price_type'], 'turio-core'); ?></span>
																				<?php endif ?>
																			</h6>
																		</div>
																	</div>
																</div>
															</div>
															</div>
													<?php
												endwhile;
												wp_reset_postdata();
											endif;
													?>



														</div>
													</div>
											<?php
										endforeach;

									endif;
											?>

									</div>
								</div>
					</div>
				</div>



		<?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Offer_Tour_Package());
