<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class turio_search_form extends Widget_Base
{

	public function get_name()
	{
		return 'turio_search_form';
	}

	public function get_title()
	{
		return esc_html__('TX Package Search', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-search';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{
		// Start  Elency Brands Control Section
		$this->start_controls_section(
			'section_general_content',
			[
				'label' => esc_html__('General', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_search_button_text',
			[
				'label'   => esc_html__('Button Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Find Now', 'turio-core'),
			]
		);


		$this->end_controls_section();
		// Start Button Widget Style
		$this->start_controls_section(
			'turio_button_widget',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_button_widget_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_button_widget_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'turio_button_widget_background_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'turio_button_widget',
				'label' => __('Border', 'turio-core'),
				'selector' => '{{WRAPPER}} .multi-main-searchber .main-form-submit button',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_typography',
				'selector' => '{{WRAPPER}} .multi-main-searchber .main-form-submit button',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_hover_typography',
				'selector' => '{{WRAPPER}} .multi-main-searchber .main-form-submit button:hover',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_hover_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .multi-main-searchber .main-form-submit button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		// End Elency Brands Control Section
	}
	protected function render()
	{

		$settings = $this->get_settings_for_display();
		$turio_theme_options = get_option('turio_theme_options'); // prefix of framework
		// if($turio_theme_options['search_enable'] == 1) :
?>
		<?php if (is_admin()) : ?>
			<script>
				jQuery('#datepicker').datepicker({
					format: 'dd-mm-yyyy',
					startDate: '+1d'
				});
				jQuery("#deatination_drop").select2({
					closeOnSelect: true,
					width: 'resolve'
				});
				jQuery(".defult-select-drowpown").select2({
					closeOnSelect: true,
				});
			</script>
		<?php endif ?>
		<?php
		$destination = get_terms(
			array(
				'taxonomy' => 'turio-package-destination',
				'hide_empty' => false
			)
		);
		$args  = [
			'posts_per_page' => -1,
			'post_type'      => 'turio-package',
			'orderby'        => 'date',
			'order'          => 'DSE',
		];
		$query   = new \WP_Query($args);

		?>
		<div class="searchbar-section">
			<div class="container">


				<div class="multi-main-searchber">
					<form method="get" action="<?php echo get_post_type_archive_link('turio-package'); ?>">
						<div class="row g-4">
							<div class="col-lg-10">
								<div class="row gx-0 gy-4">
									<div class="col-lg-3 col-md-6">
										<div class="search-box-single destination-box">
											<div class="searchbox-icon">
												<i class="bi bi-geo-alt"></i>
											</div>
											<div class="searchbox-input">
												<label><?php echo esc_html__('Destination', 'turio-core') ?></label>
												<select data-placeholder="Where Are You Going?" class="defult-select-drowpown" name="destination">
													<option value=""><?php echo esc_html__('Where Are You Going?', 'turio-core') ?></option>
													<?php
													if (!empty($destination)) {
														foreach ($destination as  $value) {
															if ($value->parent == 0) {
																echo '<optgroup label="' . esc_html($value->name) . '">';
																$id = $value->term_id;
																foreach ($destination as  $value) {

																	if ($id == $value->parent) {
																		echo '<option value="' . $value->term_id . '">' . esc_html($value->name) . '</option>';
																	} elseif ($id == $value->term_id) {
																		echo '<option value="' . $value->term_id . '">' . esc_html($value->name) . '</option>';
																	}
																}
																echo '</optgroup>';
															}
														}
													}
													?>
												</select>
											</div>
										</div>
									</div>

									<div class="col-lg-3 col-md-6">
										<div class="search-box-single type-box">
											<div class="searchbox-icon">
												<i class="bi bi-text-paragraph"></i>
											</div>

											<div class="searchbox-input">
												<label>
													<?php echo esc_html__('Travel Type', 'turio-core'); ?>
												</label>
												<select name="travel_type" class="defult-select-drowpown" data-placeholder="<?php echo esc_attr('All Activity') ?>">
													<option value=""><?php echo esc_html__('All Activity', 'turio-core') ?></option>
													<?php
													$category = get_terms('turio-package-type');
													foreach ($category as $cat) { ?>
														<option value="<?php echo sprintf(__('%s', 'turio-core'), $cat->name) ?>"><?php echo sprintf(__('%s', 'turio-core'), $cat->name) ?></option>
													<?php
													}
													?>
												</select>
											</div>
										</div>
									</div>
									<div class="col-lg-3 col-md-6">
										<div class="search-box-single type-box">
											<div class="searchbox-icon">
												<i class="bx bx-time"></i>
											</div>
											<div class="searchbox-input">
												<label><?php echo esc_html__('Duration', 'turio-core') ?></label>
												<input type="text" name="duration" placeholder="Please type duration ">
											</div>
										</div>
									</div>
									<div class="col-lg-3 col-md-6">
										<div class="search-box-single date-box">
											<div class="searchbox-icon">
												<i class="bi bi-capslock"></i>
											</div>
											<div class="searchbox-input date-picker-input">
												<label for="datepicker"><?php echo esc_html__('Journy Date', 'turio-core') ?></label>
												<input placeholder="Select your date" type="text" name="checkIn" id="datepicker" value="" class="calendar" autocomplete="off">
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-lg-2">
								<div class="main-form-submit">
									<button type="submit"><?php echo esc_html__('Find Now', 'turio-core') ?></button>
								</div>
							</div>
						</div>
					</form>
				</div>






			</div>
		</div>


<?php
	}
}

Plugin::instance()->widgets_manager->register(new turio_search_form());
