<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioTestimonialOneWidget extends Widget_Base {

	public function get_name() {
		return 'turio_testimonial';
	}

	public function get_title() {
		return esc_html__( 'TX Testimonial One', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {

		// Testimonial Header Section Start
		$this->start_controls_section(
			'turio_testimonial_one_header_setting',
			[
				'label' 		=> esc_html__('Header Settings','turio-core'),
				'tab' 			=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		// Start Header Section Switcher Option
		$this->add_control(
			'turio_testimonial_one_title_switcher',
			[
				'label' 		=> esc_html__( 'Show Heading Title', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_testimonial_one_description_switcher',
			[
				'label' 		=> esc_html__( 'Show Heading Description', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		
		$this->add_control(
			'turio_testimonial_one_navigation_switcher',
			[
				'label' 		=> esc_html__( 'Show Navigation (prev/next)', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		
		// End Header Section Switcher Option
		$this->add_control(
            'turio_testimonial_one_title',
            [
                'label' 		=> esc_html__( 'Heading Title', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> esc_html__( 'What Our Client Say About Us', 'turio-core' ),
                'label_block' 	=> true,
         
        	]
        );
		$this->add_control(
            'turio_testimonial_one_sub_title',
            [
                'label' 		=> esc_html__( 'Heading Description', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXTAREA,
                'default' 		=> esc_html__( 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consectetur.', 'turio-core' ),
                'label_block' 	=> true,
            ]
        );
       
		$this->end_controls_section();

		// Testimonial Header Section End
		// Testimonial General Settings
		$this->start_controls_section(
			'turio_testimonial_one_general_setting',
			[
				'label'  		=> esc_html__('General','turio-core'),
				'tab'    		=> Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_control(
			'turio_testimonial_one_rating_switcher',
			[
				'label' 		=> esc_html__( 'Show Rating', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value'  => 'yes',
				'default' 		=> 'yes',
			]
		);
		 $this->add_control(
			'turio_testimonial_icon',
			[
				'label' 		=> esc_html__( 'Choose Quote Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::ICONS,
				'default' 		=> [
					'value' 	=> 'bx bxs-quote-left',
					'library' 	=> 'solid',
				],
                'label_block' 	=> true
			]
		);
		$this->end_controls_section();
		// End Testimonial General Settings


		// Testimonial Lists Section Start
		$this->start_controls_section(
			'turio_testimonial_lists',
			[
				'label' 		=> esc_html__( 'Testimonial Lists', 'turio-core' )
			]
		);

        $repeater = new Repeater();
		$repeater->add_control(
			'turio_testimonial_author_image',
			[
				'label'   		=> esc_html__( 'Choose Image', 'turio-core' ),
				'type'    		=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$repeater->add_control(
			'turio_testimonial_author_name',
			[
				'label'       	=> esc_html__( 'Name', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXT,
				'default'     	=> esc_html__( 'John Due', 'turio-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'turio_testimonial_one_rating',
			[
				'label' 		=> esc_html__( 'Rating', 'turio-core' ),
				'type' 			=> Controls_Manager::NUMBER,
				'min' 			=> 0,
				'max' 			=> 5,
				'step' 			=> 1,
				'default' 		=> 5,
				'dynamic' 		=> [
					'active' 	=> true,
				],
			]
		);
        $repeater->add_control(
			'turio_testimonial_author_description',
			[
				'label'       	=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'default'     	=> esc_html__( 'but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages', 'turio-core' ),
			]
		);

		$this->add_control(
			'turio_testimonial_list',
			[
				'label' 		=> __( 'Testimonial List', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default'		=> [
					[
						'turio_testimonial_author_name'     => esc_html__( 'Adam Groff', 'turio-core' ),
						'turio_brand_item_default_active'   => 'yes'
					],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Lilyan Danclark', 'turio-core' ) ],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Shwan Pull', 'turio-core' ) ],
				],
				'title_field'   => '{{turio_testimonial_author_name}}'
			  ,
			]
		);

		$this->end_controls_section();

		// Testimonial Lists Section End

		// Start Testimonial One Style
		$this->start_controls_section(
			'turio_testimonial_one_general_style',
			[
				'label'  		=> esc_html__('General'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		);
		// Background Control
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'turio_testimonial_one_section_background',
                'label' => esc_html__( 'Background', 'turio-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .testimonial-style-one',
                'fields_options' => [
					'background' => [
						'label' => esc_html__('Background (Color/Image)', 'turio-core'),
						'default' => 'classic',
					],
				],
            ]
        );
		$this->end_controls_section();
		// Start Testimonial Title Style
		$this->start_controls_section(
			'turio_testimonial_one_title_style',
			[
				'label'   		=> esc_html__('Heading Title','turio-core'),
				'tab'     		=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                'turio_testimonial_one_title_switcher' => 'yes',
            	]   
			]
		);
		$this->add_control(
			'turio_testimonial_one_title_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'default' 		=> '#fff',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .section-head-alpha h2' => 'color: {{VALUE}};',
				],

			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_one_title_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-style-one .section-head-alpha h2',

			]
		);
		$this->end_controls_section();
		// End Testimonial Title Style
		// Start Testimonial Description Style
		$this->start_controls_section(
			'turio_testimonial_one_description_style',
			[
				'label'  		=> esc_html__('Heading Description'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                'turio_testimonial_one_description_switcher' => 'yes',
            	] 
			]
		);
		$this->add_control(
			'turio_testimonial_one_description_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .section-head-alpha p' => 'color : {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_one_description_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-style-one .section-head-alpha p',

			]
		);

		$this->end_controls_section();
		// End Testimonial Description Style
		// Start Testimonial Navigation Icon Style
		$this->start_controls_section(
			'turio_testimonial_icon_style',
			[
				'label'  		=> esc_html__('Navigation (prev/next)','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_testimonial_one_navigation_switcher' => 'yes'
				]
			]
		);

		$this->add_control(
            'turio_testimonial_icon_style_color',
            [
                'label'     	=> esc_html__('Icon Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'turio_testimonial_icon_bg_style_color',
            [
                'label'     	=> esc_html__('Background Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'default'   	=> '#ffb6af',
                'selectors' 	=> [
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows .testi-prev4' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows .testi-next4' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'turio_testimonial_icon_style_hover_color',
            [
                'label'     	=> esc_html__('Hover Icon Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows i:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'turio_testimonial_icon_style_bg_hover_color',
            [
                'label'     	=> esc_html__('Hover Background Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows .testi-prev4::before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .testimonial-style-one .slider-arrows .testi-next4::before' => 'background: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();
		//Start Box-Settings
		$this->start_controls_section(
			'turio_testimonial_one_box_setting_style',
			[
				'label'  		=> esc_html__('Box Setting'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		);
		$this->add_control(
			'turio_testimonial_one_box_background_color',
			[
				'label' => esc_html__( 'Background Color', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-card-beta' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_one_box_background_hover_color',
			[
				'label' => esc_html__( 'Hover Background', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-card-beta:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_one_box_border_hover_color',
			[
				'label' => esc_html__( 'Hover Border', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-card-beta::before' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'turio_testimonial_one_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-card-beta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		 $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_package_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-card-beta',
			]
		);
		$this->end_controls_section();
		// Name Style
		$this->start_controls_section(
			'turio_testimonial_one_author_name_style',
			[
				'label' 		=> esc_html__( 'Name', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_name_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .reviewer-name' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_author_name_style_hover_color',
			[
				'label'     	=> esc_html__( 'Hover Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .reviewer-name:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_one_author_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .reviewer-name',

			]
		);
		$this->end_controls_section();
		// End Name Style
		// Start Rating Control Style
		$this->start_controls_section(
			'turio_testimonial_rating_control_style',
			[
				'label' 		=> esc_html__('Rating','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_testimonial_one_rating_switcher'  	=> 'yes'
				]
			]
		);
		$this->add_control(
			'turio_testimonial_rating_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .reviewer-rating li i' => 'color: {{VALUE}};',
				],
			]
		);
 		$this->add_control(
			'turio_testimonial_rating_icon_style_size',
			[
				'label' 		=> esc_html__( 'Size', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 1,
					]
				],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> 16,
				],
                'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .reviewer-rating li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Rating Control Style
		// Start Quote Icon Style
		$this->start_controls_section(
			'turio_testimonial_one_icon_style',
			[
				'label' 		=> esc_html__( 'Quote Icon', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,

			]
		);
        $this->add_control(
			'turio_testimonial_one_icon_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '#F4F5F5',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .testimonial-quote-icon .qoute-icon i'   => 'color: {{VALUE}};',
          			'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .qoute-icon svg path' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_one_icon_style_hover_color',
			[
				'label'  		=> esc_html__('Hover Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'default' 		=> '#00152b',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-beta:hover .testimonial-quote-icon .qoute-icon i' => 'color: {{VALUE}};',
				],

			]
		);
		$this->add_control(
			'turio_testimonial_one_icon_style_size',
			[
				'label' 		=> esc_html__( 'Width', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 2,
					],
					'%' => [
						'min' 	=> 0,
						'max' 	=> 100,
					],
				],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> 40,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .testimonial-quote-icon .qoute-icon i'   => 'font-size:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .qoute-icon svg' => 'width:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .qoute-icon svg' => 'height:  {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'turio_testimonial_one_icon_style_quote_size',
			[
				'label' => esc_html__( 'Margin', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .qoute-icon i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Quote Icon Style
		// Description Style
		$this->start_controls_section(
			'turio_testimonial_author_description_style',
			[
				'label' 		=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_description_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta .review-texts p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_author_description_hover_color',
			[
				'label'     	=> esc_html__( 'Hover Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-style-one .testimonial-card-beta p:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_author_description_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-style-one .testimonial-card-beta p',

			]
		);

	
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		

	}
	
	protected function render() {

		$settings = $this->get_settings_for_display(); 

		if (is_admin()) {
			?>
			<script>
		    (function ($) {
		        var testimonialSliderOne = new Swiper('.testimonial-slider-one', {
						slidesPerView: 1,
						speed: 1000,
						spaceBetween: 20,
						loop: true,
						roundLengths: true,
						autoplay: {
						delay: 15000
						},
						navigation: {
						nextEl: '.testi-next',
						prevEl: '.testi-prev',
						},
						breakpoints: {
						480:{
							slidesPerView: 1
						},
						768:{
							slidesPerView: 1
						},
						992:{ 
							slidesPerView: 2
						},
						1200:{
							slidesPerView: 3
						},
						
						}
				});
		    })(jQuery);
			</script>
		<?php
		}
	?>

	<div class="testimonial-area testimonial-style-one pt-110 pb-110 ">
        <div class="container">
            <div class="row d-flex justify-content-center align-items-center">
				<div class="<?php if($settings['turio_testimonial_one_navigation_switcher'] == 'yes') { echo "col-lg-9 col-sm-12";} else{ echo "col-lg-12"; } ?>">
					<div class="section-head-alpha text-lg-start text-center">
						<?php if (!empty($settings['turio_testimonial_one_title']) && $settings['turio_testimonial_one_title_switcher'] == 'yes'): ?>
							<h2><?php  echo $settings['turio_testimonial_one_title'] ?></h2>
						<?php endif ?>
						<?php if (!empty($settings['turio_testimonial_one_sub_title']) && $settings['turio_testimonial_one_description_switcher'] == 'yes'): ?>
							<p><?php echo $settings['turio_testimonial_one_sub_title']; ?></p>
						<?php endif ?>
					</div>
				</div>
				<?php if (!empty($settings['turio_testimonial_one_navigation_switcher']) && $settings['turio_testimonial_one_navigation_switcher'] == 'yes'): ?>
                	<div class="col-lg-3 col-sm-10 d-flex justify-content-end">
						<div class="slider-arrows text-center d-lg-flex flex-row d-none gap-5">
							<div class="testi-prev4" tabindex="0" role="button" aria-label="Previous slide"> <i class="bi bi-arrow-left"></i></div>
							<div class="testi-next4" tabindex="0" role="button" aria-label="Next slide"><i class="bi bi-arrow-right"></i></div>
						</div>
					</div>
                <?php endif ?>
            </div>
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-12">
                    <div class="swiper testimonial-slider-one" >
                        <div class="swiper-wrapper">
						<?php 
							$k = 0;
							if(!empty($settings['turio_testimonial_list'])) :

								foreach ( $settings['turio_testimonial_list'] as $item ) :
								$k++;
							?>
                            <div class="swiper-slide">
                                <div class="testimonial-card-beta mx-auto wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($k+1)*2 ?>00ms">
                                    <div class="testimonial-quote-icon">
										<?php if (!empty($settings['turio_testimonial_icon'])): ?>
											<div class="qoute-icon">
												<?php \Elementor\Icons_Manager::render_icon( $settings['turio_testimonial_icon'], [ 'aria-hidden' => 'true' ] ); ?>
											</div>
										<?php endif ?>
                                    </div>
                                    <div class="testimonial-card-body">
                                        <div class="testimonial-info">
                                            <div class="reviewr-info">
												<?php if(!empty($item['turio_testimonial_author_image'])) : ?>
													<div class="single-thumb">
														<img class="img-fluid" src="<?php echo esc_url($item['turio_testimonial_author_image']['url']); ?>" alt="<?php if(!empty($item['turio_testimonial_author_image']['alt'])){echo $item['turio_testimonial_author_image']['alt']; }; ?>">       
													</div>
												<?php  endif; ?>                                                
												<div class="reviwer-info-cotn">
													<?php if (!empty($item['turio_testimonial_author_name'])): ?>
														<h4 class="reviewer-name"><?php echo esc_html__( $item['turio_testimonial_author_name'] ); ?></h4>
													<?php endif ?>
													<?php if (!empty($settings['turio_testimonial_one_rating_switcher']) && $settings['turio_testimonial_one_rating_switcher'] == 'yes'): ?>
														<ul class="reviewer-rating gap-2">
															<?php
																for ($i=0; $i <$item['turio_testimonial_one_rating'] ; $i++) {  ?>
																<li><i class="bi bi-star-fill"></i></li>	
															<?php	}
															?>
															
														</ul>
													<?php endif ?>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        <div class="review-texts">
										<?php if (!empty($item['turio_testimonial_author_description'])): ?>
											<p>
												<?php echo esc_html__( $item['turio_testimonial_author_description'] ) ?>
											</p>
										<?php endif ?>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>


							<?php 
							endforeach;
						endif;
						?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php	}
}

Plugin::instance()->widgets_manager->register( new TurioTestimonialOneWidget() );