<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioTeamWidget extends Widget_Base {

	public function get_name() {
		return 'turio_tour_guides_one';
	}

	public function get_title() {
		return esc_html__( 'TX Tour Guides One', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
			'section_team_item',
			[
				'label' => esc_html__( 'General', 'turio-core' )
			]
		);
		$this->add_control(
			'turio_tour_guides_one_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);
		
		$repeater = new Repeater();
		$repeater->add_control(
			'turio_team_image',
			[
				'label'   => esc_html__( 'Choose Image', 'turio-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'turio_team_name',
			[
				'label'       => esc_html__( 'Name', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Sakura Chen', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_team_designation',
			[
				'label'       => esc_html__( 'Designation', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Tour Guide', 'turio-core' ),
				'label_block' => true,
			]
		);
		// start popcover
        $repeater->add_control(
            'popover-toggle_social',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Social media', 'turio-core' ),
                'label_off' => esc_html__( 'Default', 'turio-core' ),
                'label_on' => esc_html__( 'Custom', 'turio-core' ),
                'return_value' => 'yes',
            ]
        );
		$repeater->start_popover();
        $repeater->add_control(
			'turio_team_instagram',
			[
				'label'       => esc_html__( 'Instagram', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.instagram.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'turio_team_facebook',
			[
				'label'       => esc_html__( 'Facebook', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.facebook.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'turio_team_twitter',
			[
				'label'       => esc_html__( 'Twitter', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://twitter.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'turio_team_linkedin',
			[
				'label'       => esc_html__( 'Linkedin', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( '', 'turio-core' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'turio_team_youtube',
			[
				'label'       => esc_html__( 'Youtube', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( '', 'turio-core' ),
				'label_block' => true,
			]
		);
       
        
        $repeater->add_control(
			'turio_team_whatsapp',
			[
				'label'       => esc_html__( 'Whatsapp', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.whatsapp.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->end_popover();
	
		$this->add_control(
			'turio_team_list',
			[
				'label'   => esc_html__( 'Tour Guides List', 'turio-core' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'turio_team_name'   => esc_html__( 'Marvin McKinney', 'turio-core' ),
					],
					[
						'turio_team_name'   => esc_html__( 'Charlotte Sophia', 'turio-core' ),
					],
					[
						'turio_team_name'   => esc_html__( 'Brooklyn Simmons', 'turio-core' ),
					],
				],
				'title_field' => '{{{ turio_team_name }}}',
			]
		);

		$this->end_controls_section();

		// Team Item
		$this->start_controls_section(
			'turio_team_item_name_style',
			[
				'label' => esc_html__( 'Name', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    => esc_html__( 'Typography', 'turio-core' ),
				'name'     => 'turio_team_name_typography',
				'selector' => '{{WRAPPER}} .guide-card-alpha .guide-content .guide-name',

			]
		);
		
		$this->add_control(
			'turio_team_name_color',
			[
				'label'     => esc_html__( 'Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-content .guide-name' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

			// Team Item
			$this->start_controls_section(
				'turio_team_designation_style',
				[
					'label' => esc_html__( 'Designation', 'turio-core' ),
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			// Designation 
			$this->add_group_control(
				Group_Control_Typography:: get_type(),
				[
					'label'    => esc_html__( 'Typography', 'turio-core' ),
					'name'     => 'turio_team_designation_typography',
					'selector' => '{{WRAPPER}} .guide-card-alpha .guide-content .guide-designation',
	
				]
			);
			
			$this->add_control(
				'turio_team_designation_color',
				[
					'label'     => esc_html__( 'Color', 'turio-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .guide-card-alpha .guide-content .guide-designation' => 'color: {{VALUE}};',
					],
				]
			);
	
			$this->end_controls_section();
        $this->start_controls_section(
			'turio_team_item_social_style',
			[
				'label' => esc_html__( 'Social Media', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'turio_team_social_bg_color',
			[
				'label'     => esc_html__( 'Card Background', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-image .guide-social-links' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_team_social_color',
			[
				'label'     => esc_html__( 'Icon Color', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-image .guide-social-links li a' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_team_social_icon_bg_color',
			[
				'label'     => esc_html__( 'Icon Background', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-image .guide-social-links li a' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_team_social_hover_color',
			[
				'label'     => esc_html__( 'Icon Color (Hover)', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-image .guide-social-links li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_team_social_bg_hover_color',
			[
				'label'     => esc_html__( 'Icon Background (Hover)', 'turio-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-alpha .guide-image .guide-social-links li a:hover' => 'background: {{VALUE}};',
				],
			]
		);
        $this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
?>

		<div class="guide-area guide-style-one wow animate fadeInUp"  data-wow-duration="1500ms" data-wow-delay="200ms">
		<div class="container">
			<div class="row g-4">
			<?php 
			if(!empty($settings['turio_team_list'])) :
				$num = 0;
				foreach ( $settings['turio_team_list'] as $item ) :
				$num ++;
			?>
				<?php if( $settings['turio_tour_guides_one_column_section'] == 'column_two' ) : ?>
					<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
				<?php elseif ($settings['turio_tour_guides_one_column_section'] == 'column_three') : ?>
					<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
				<?php elseif ($settings['turio_tour_guides_one_column_section'] == 'column_four') : ?>
					<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
				<?php endif ?>
					<div class="guide-card-alpha  wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
						<div class="guide-image">
						<img src="<?php echo $item['turio_team_image']['url'];?>" alt="<?php echo esc_attr($item['turio_team_name']);?>" class="img-fluid">
							<ul class="guide-social-links">
								<?php 
									if(!empty($item['turio_team_instagram'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_instagram']);?>"><i class='bx bxl-instagram'></i></a>
										</li>
									<?php 
									}
								?>

								<?php 
									if(!empty($item['turio_team_facebook'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_facebook']);?>"><i class='bx bxl-facebook'></i></a>
										</li>
									<?php 
									}
								?>
								
								<?php 
									if(!empty($item['turio_team_twitter'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_twitter']);?>"><i class='bx bxl-twitter'></i></a>
										</li>
									<?php 
									}
								?>
								
								<?php 
									if(!empty($item['turio_team_whatsapp'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_whatsapp']); ?>"><i class='bx bxl-whatsapp'></i></a>
										</li>
									<?php 
									}
								?>
								<?php 
									if(!empty($item['turio_team_linkedin'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_linkedin']); ?>"><i class='bx bxl-linkedin'></i></a>
										</li>
									<?php 
									}
								?>
								<?php 
									if(!empty($item['turio_team_youtube'])){
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_team_youtube']); ?>"><i class='bx bxl-whatsapp'></i></a>
										</li>
									<?php 
									}
								?>
								
							</ul>
						</div>
						<div class="guide-content">
                            <h4 class="guide-name">
							<?php
								if(!empty($item['turio_team_name'])){
									echo esc_html( $item['turio_team_name'] );
								}
							?>
							</h4>
                            <h6 class="guide-designation">
							<?php
								if(!empty($item['turio_team_designation'])){
									echo esc_html( $item['turio_team_designation'] );
								}
							?>
							</h6>
                        </div>
                    </div>
                </div>
				<?php 
					endforeach;
				endif;
					?>
            </div>
        </div>
    </div>


		<?php
	}
}

Plugin::instance()->widgets_manager->register( new TurioTeamWidget() );
