<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Tour_Guides_Three extends Widget_Base
{

	public function get_name()
	{
		return 'turio_tour_guides_three';
	}

	public function get_title()
	{
		return esc_html__('TX Tour Guides Three', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-person';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{


		$this->start_controls_section(
			'section_tour_guides_item',
			[
				'label' => esc_html__('General', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_tour_guides_three_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'turio_tour_guides_image',
			[
				'label'   => esc_html__('Tour Guides Image', 'turio-core'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'turio_tour_guides_name',
			[
				'label'       => esc_html__('Name', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Sakura Chen', 'turio-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_designation',
			[
				'label'       => esc_html__('Designation', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Tour Guide', 'turio-core'),
				'label_block' => true,
			]
		);
		// start popcover
        $repeater->add_control(
            'popover-toggle_social',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Social media', 'turio-core' ),
                'label_off' => esc_html__( 'Default', 'turio-core' ),
                'label_on' => esc_html__( 'Custom', 'turio-core' ),
                'return_value' => 'yes',
            ]
        );

        $repeater->start_popover();
		$repeater->add_control(
			'turio_tour_guides_instagram',
			[
				'label'       => esc_html__('Instagram', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.instagram.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_facebook',
			[
				'label'       => esc_html__('Facebook', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.facebook.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_twitter',
			[
				'label'       => esc_html__('Twitter', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://twitter.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_linkedin',
			[
				'label'       => esc_html__('Linkedin', 'turio-core'),
				'default'     => esc_html__( '', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_whatsapp',
			[
				'label'       => esc_html__('Whatsapp', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'https://www.whatsapp.com/', 'turio-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'turio_tour_guides_youtube',
			[
				'label'       => esc_html__('Youtube', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( '', 'turio-core' ),
				'label_block' => true,
			]
		);


		
		$repeater->end_popover();
		$this->add_control(
			'turio_tour_guides_list',
			[
				'label'   => esc_html__('Tour Guides List', 'turio-core'),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'turio_tour_guides_name'   => esc_html__('Sebastian Mateo', 'turio-core'),
					],
					[
						'turio_tour_guides_name'   => esc_html__('Theodore Aiden', 'turio-core'),
					],
					[
						'turio_tour_guides_name'   => esc_html__('Lincoln Anthony', 'turio-core'),
					],
				],
				'title_field' => '{{{ turio_tour_guides_name }}}',
			]
		);

		$this->end_controls_section();
		// Start Tour Guides Box Deisgn Style
        $this->start_controls_section(
            'turio_tour_guides_box_design_style',
            [
                'label'   		=> esc_html__('Box Setting','turio-core'),
                'tab'      		=> Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'turio_tour_guides_box_design_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'turio_tour_guides_box_design_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .guide-card-beta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                ],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_tour_guides_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .guide-card-beta',
			]
		);
        
        $this->end_controls_section();
        // End Tour Guides Box Design Style
		$this->start_controls_section(
			'turio_tour_guides_item_name_style',
			[
				'label' => esc_html__('Name', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_tour_guides_name_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-content .guide-name' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_tour_guides_name_typography',
				'selector' => '{{WRAPPER}} .guide-card-beta .guide-content .guide-name',

			]
		);
		$this->add_responsive_control(
			'turio_tour_guides_name_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .guide-card-beta .guide-content .guide-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_responsive_control(
            'turio_tour_guides_name_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .guide-card-beta .guide-content .guide-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'turio_tour_guides_designation_style',
			[
				'label' => esc_html__('Designation', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_tour_guides_designation_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-content .guide-designation' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_tour_guides_designation_typography',
				'selector' => '{{WRAPPER}} .guide-card-beta .guide-content .guide-designation',

			]
		);
		$this->add_responsive_control(
			'turio_tour_guides_designation_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .guide-card-beta .guide-content .guide-designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

        $this->add_responsive_control(
            'turio_tour_guides_designation_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .guide-card-beta .guide-content .guide-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'turio_tour_guides_item_social_style',
			[
				'label' => esc_html__('Social Icon', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_tour_guides_social_color',
			[
				'label'     => esc_html__('Icon Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links li a' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_tour_guides_social_background',
			[
				'label'     => esc_html__('Icon Background', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links li a' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_tour_guides_social_hover_color',
			[
				'label'     => esc_html__('Icon Color (Hover)', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_tour_guides_social_hover_background',
			[
				'label'     => esc_html__('Icon Background (Hover)', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links li a:hover' => 'background: {{VALUE}};',
				],
			]
		);
        $this->add_responsive_control(
			'turio_tour_guides_social_icon_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',                ],
			]
		);
        $this->add_control(
			'turio_tour_guides_social_hover_card_background',
			[
				'label'     => esc_html__('Icon Background (Card) ', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .guide-card-beta .guide-image .guide-social-links' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
    ?>
        <div class="guide-area guide-style-one">
			<div class="row d-flex justify-content-center gy-4 gx-0">
				<?php
				if (!empty($settings['turio_tour_guides_list'])) :
					$num = 0;
					foreach ($settings['turio_tour_guides_list'] as $item) :
					$num++;
				?>
				<?php if( $settings['turio_tour_guides_three_column_section'] == 'column_two' ) : ?>
					<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
				<?php elseif ($settings['turio_tour_guides_three_column_section'] == 'column_three') : ?>
					<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
				<?php elseif ($settings['turio_tour_guides_three_column_section'] == 'column_four') : ?>
					<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
				<?php endif ?>
					<div class="guide-card-beta wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
						<div class="guide-image">
							<img src="<?php echo $item['turio_tour_guides_image']['url']; ?>" alt="tour_guides_image">
							<ul class="guide-social-links d-flex justify-content-center flex-column gap-3">
								<?php
									if (!empty($item['turio_tour_guides_instagram'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_instagram']); ?>"><i class='bx bxl-instagram'></i></a>
										</li>
									<?php
									}
									?>

									<?php
									if (!empty($item['turio_tour_guides_facebook'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_facebook']); ?>"><i class='bx bxl-facebook'></i></a>
										</li>
									<?php
									}
									?>

									<?php
									if (!empty($item['turio_tour_guides_twitter'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_twitter']); ?>"><i class='bx bxl-twitter'></i></a>
										</li>
									<?php
									}
									?>
									<?php
									if (!empty($item['turio_tour_guides_linkedin'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_linkedin']); ?>"><i class='bx bxl-linkedin'></i></a>
										</li>
									<?php
									}
									?>

									<?php
									if (!empty($item['turio_tour_guides_whatsapp'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_whatsapp']); ?>"><i class='bx bxl-whatsapp'></i></a>
										</li>
									<?php
									}
									?>

									<?php
									if (!empty($item['turio_tour_guides_youtube'])) {
									?>
										<li>
											<a href="<?php echo esc_url($item['turio_tour_guides_youtube']); ?>"><i class='bx bxl-youtube'></i></a>
										</li>
									<?php
									}
								?>
							</ul>
						</div>

						<div class="guide-content">
							<h4 class="guide-name">
								<?php
								if (!empty($item['turio_tour_guides_name'])) {
									echo esc_html($item['turio_tour_guides_name']);
								}
								?>
							</h4>
							<h6 class="guide-designation">
								<?php
								if (!empty($item['turio_tour_guides_designation'])) {
									echo esc_html($item['turio_tour_guides_designation']);
								}
								?>
							</h6>
						</div>
					</div>
				</div>
				<?php
					endforeach;
				endif;
				?>    
			</div>
        </div>       
    <?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Tour_Guides_Three());
