<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioPackageByDestinationWidget extends Widget_Base
{

	public function get_name()
	{
		return 'turio_package_list_by_destination';
	}

	public function get_title()
	{
		return esc_html__('TX Package By Destination', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-post-list';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{


		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__('General', 'turio-core')
			]
		);

        // Select Option
        $this->add_control(
            'turio_package_destination_select',
            [
                'label'     => esc_html__( 'Select Style', 'turio-core' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'style_one',
                'options'   => [
                    'style_one'      => esc_html__( 'Style One', 'turio-core' ),
                    'style_two'      => esc_html__( 'Style Two', 'turio-core' ),
                ],
            ]
        );
		$this->add_control(
			'turio_package_destination_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);

		$this->add_control(
			'turio_package_by_destination_duration_switcher',
			[
				'label' 		=> esc_html__( 'Show Duration', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off'     => esc_html__( 'Disable', 'turio-core' ),
				'return_value'  => 'yes',
				'default'    	=> 'yes',
			]
		);
		$this->add_control(
			'turio_package_by_destination_duration_icon_switcher',
			[
				'label' 		=> esc_html__( 'Show Duration Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on'	 	=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value'  => 'yes',
				'default' 		=> 'yes',
				'condition'		=> [
				'turio_package_by_destination_duration_switcher' 	=> 'yes',
				]
			]
		);
		$this->add_control(
			'turio_package_by_destination_button_icon_switcher',
			[
				'label' 		=> esc_html__( 'Show Button Arrow Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
                'condition' => [
                    'turio_package_destination_select' => 'style_one'
                ]
			]
		);
		$this->add_control(
			'turio_package_by_destination_button_text',
			[
				'label'  		=> esc_html__('Button Text','turio-core'),
				'type'    		=> Controls_Manager::TEXT,
				'default' 		=> esc_html__('Book Now','turio-core'),
				'label_block' 	=> true,
                'condition' => [
                    'turio_package_destination_select' => 'style_one'
                ]
			]
		);
		$this->add_control(
			'package_destination',
			[
				'label' 		=> __('Destination', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple'    	=> true,
				'options'     	=> turio_core()->get_terms_names('turio-package-destination', 'id'),
				'default'     	=> turio_core()->get_all_terms_names('turio-package-destination','id')
			]
		);

		$this->add_control(
			'turio_package_by_destination_post_per_page',
			[
				'label'  			=> esc_html__('Post Per Page','turio-core'),
				'type'    			=> Controls_Manager::NUMBER,
				'default' 			=> 6,
				'label_block' 		=> false,
			]
		);
		$this->add_control(
			'orderby',
			[
				'label'   		 => esc_html__('Order By', 'turio-core'),
				'type'    		 => Controls_Manager::SELECT,
				'default' 		 => 'date',
				'options' 		 => [
					'ID'         => esc_html__('Post Id', 'turio-core'),
					'author'     => esc_html__('Post Author', 'turio-core'),
					'title'      => esc_html__('Title', 'turio-core'),
					'date'       => esc_html__('Date', 'turio-core'),
					'rand'       => esc_html__('Random', 'turio-core'),
					'menu_order' => esc_html__('Menu Order', 'turio-core'),
				],
			]
		);
		$this->add_control(
			'order',
			[
				'label'   		=> esc_html__('Order', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options' 		=> [
					'asc'  		=> esc_html__('Ascending', 'turio-core'),
					'desc' 		=> esc_html__('Descending', 'turio-core')
				],
				'default' => 'desc',
			]
		);

		$this->end_controls_section();

		

		// Start Package Box Deisgn Style
        $this->start_controls_section(
            'turio_package_box_design_style',
            [
                'label'   		=> esc_html__('Box Setting','turio-core'),
                'tab'      		=> Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_responsive_control(
			'turio_package_box_design_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .package-area .package-card-alpha' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .package-delta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_package_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-alpha',
				'condition' => [
					'turio_package_destination_select' => 'style_one',
				],
			]
		);
        
        $this->end_controls_section();
        // End Package Box Design Style
		// Start Package Duration Style One
        $this->start_controls_section(
            'turio_package_duration_style_one',
            [
                'label' 		=> esc_html__('Duration','turio-core'),
                'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition' => [
                    'turio_package_destination_select' => 'style_one'
				], 
            ]
        );
        $this->add_control(
            'turio_package_style_one_duration_color',
            [
                'label'  		=> esc_html__('Color','turio-core'),
                'type'   		=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel' => 'color : {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_duration_style_one_typography',
				'selector' 		=> '{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel',
			]
		);
        $this->add_control(
            'duration_style_one_background_color',
            [
                'label' => esc_html__( 'Background Color', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'turio_package_duration_style_one_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
            'turio_package_duration_style_one_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
			'turio_package_duration_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .package-card-alpha .package-thumb .card-lavel' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->end_controls_section();
        // Start Package Main Title Style
		$this->start_controls_section(
			'turio_package_main_title_style',
			[
				'label' 		=> esc_html__('Title', 'turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_main_title_style_color',
			[
				'label'     	=> esc_html__('Color', 'turio-core'),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body h3' => 'color: {{VALUE}};',
					'{{WRAPPER}} .package-delta .text h4 a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_package_main_title_style_typography',
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body h3,.package-delta .text h4 a',
			]
		);
		$this->add_control(
            'title_color_hoverr',
            [
                'label' => esc_html__( 'Hover Color', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-card-alpha .package-card-body .p-card-title a:hover' => 'color: {{VALUE}}',
                ],
				'condition' => [
                    'turio_package_destination_select' => 'style_one'
				], 
            ]
        );
		$this->add_responsive_control(
			'turio_package_main_title_style_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-area .package-card-body h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .package-delta .text h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
            'turio_package_main_title_style_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-area .package-card-body h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .package-delta .text h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
		//Start Destination Address
		$this->start_controls_section(
			'turio_package_destination_style_one',
			[
				'label' 		=> esc_html__('Destination Address','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_package_destination_select' => 'style_one'
				], 
			]
		);
		$this->add_control(
			'turio_package_price_style_one_destination_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-card-alpha .package-card-body h6.destination-address' => 'color : {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_price_style_one_destination_typography',
				'selector' 		=> '{{WRAPPER}} .package-card-alpha .package-card-body h6.destination-address',
			]
		);
		$this->end_controls_section();
        // Start Package Duration Style
        $this->start_controls_section(
            'turio_package_duration_style',
            [
                'label' 		=> esc_html__('Duration','turio-core'),
                'tab'  			=> Controls_Manager::TAB_STYLE,
                'condition'		=> [
                	'turio_package_by_destination_duration_switcher'  	=> 'yes'
                ],
				'condition' => [
                    'turio_package_destination_select' => 'style_two'
                ]
				
            ]
        );
		$this->add_control(
            'turio_package_duration_text_color',
            [
                'label'     	=> esc_html__('Color','turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .package-area .package-thumb p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .package-delta .text > span' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_package_duration_text_style',
				'selector' 		=> '{{WRAPPER}} .package-area .package-thumb p, .package-delta .text > span',
			]
		);
		$this->add_responsive_control(
			'turio_package_duration_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-delta .text > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
            'turio_package_duration_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-delta .text > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        // End Package Duration Style
        // Start Package Button Setting
        $this->start_controls_section(
            'turio_package_button_style',
            [
                'label'   		=> esc_html__('Button','turio-core'),
                'tab'     		=> Controls_Manager::TAB_STYLE,  
                'condition' => [
                    'turio_package_destination_select' => 'style_one'
				], 

            ]
        );


		$this->add_responsive_control(
			'turio_package_button_padding',
			[
				'label'      	=> __('Padding', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_package_button_margin',
			[
				'label'        	=> __('Margin', 'turio-core'),
				'type'         	=> Controls_Manager::DIMENSIONS,
				'size_units'   	=> ['px', '%'],
				'selectors'    	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' 		=> __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __('Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_one_bg_color',
			[
				'label' 		=> __('Background Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 			=> 'button_one_border_typhography',
				'label' 		=> __('Border', 'turio-core'),
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body .book-btn a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_button_typography',
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body .book-btn a',

			]
		);

		$this->add_responsive_control(
			'turio_package_button_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' 		=> __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' 		=> __('Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' 		=> __('Background Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' 		=> __('Border Color', 'turio-core'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_button_hover_typography',
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body .book-btn a:hover',

			]
		);

		$this->add_responsive_control(
			'turio_package_button_hover_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .package-area .package-card-body .book-btn a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        // End Package Button Style
		// Start Package Price Style One
		$this->start_controls_section(
			'turio_package_price_style_one',
			[
				'label' 		=> esc_html__('Price','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_package_destination_select' => 'style_one'
				], 
			]
		);
		$this->add_control(
			'turio_package_price_style_one_price_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-area .package-card-body .p-card-info h6' => 'color : {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_price_style_one_typography',
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body .p-card-info h6',
			]
		);
		$this->end_controls_section();
        // Start Package Price Style Two
        $this->start_controls_section(
            'turio_package_price',
            [
                'label' 		=> esc_html__('Price','turio-core'),
                'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition' => [
                    'turio_package_destination_select' => 'style_two'
				], 
            ]
        );
        $this->add_control(
            'turio_package_price_style_two_new_price_color',
            [
                'label'  		=> esc_html__('New Price Color','turio-core'),
                'type'   		=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .package-delta .package-badge' => 'color : {{VALUE}};',
                ]
            ]
        );
		$this->add_control(
            'turio_package_price_style_two_old_price_color',
            [
                'label'  		=> esc_html__('Old Price Color','turio-core'),
                'type'   		=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .package-delta .package-badge del' => 'color : {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_price_style_two_typography',
				'selector' 		=> '{{WRAPPER}} .package-delta .package-badge',
			]
		);
        //price background
        $this->add_control(
            'price_bac_color',
            [
                'label' => esc_html__( 'Background Color', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-delta .package-badge' => 'background: {{VALUE}}',
                ],
            ]
        );
        //price background hover
        $this->add_control(
            'price_bac_color_hover',
            [
                'label' => esc_html__( 'Background Hover', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .package-delta .package-badge:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'turio_package_price_style_two_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .package-delta .package-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
            'turio_package_price_style_two_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .package-delta .package-badge' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        // End Package Price Style
        // Start Price Type Style
        $this->start_controls_section(
            'turio_package_price_type',
            [
                'label'   		=> esc_html__('Price Type'),
                'tab'     		=> Controls_Manager::TAB_STYLE,
                'condition' => [
                    'turio_package_destination_select' => 'style_one'
				], 
            ]
        );
        $this->add_control(
            'turio_package_price_type_style',
            [
                'label'   		=> esc_html__('Color','turio-core'),
                'type'    		=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .package-area .package-card-body .p-card-info span' => 'color : {{VALUE}}',
                ] 
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_package_price_type_style_typography',
				'selector' 		=> '{{WRAPPER}} .package-area .package-card-body .p-card-info span',

			]
		);
        $this->end_controls_section();
        // End Price Type Style
	}

	protected function render()
	{

	$settings = $this->get_settings_for_display();

	$args = array(
		'post_type'      		=> 'turio-package',
		'posts_per_page' 		=> $settings['turio_package_by_destination_post_per_page'],
		'orderby'        		=> $settings['orderby'],
		'order'          		=> $settings['order'],
		'post_status'    		=> 'publish'
	);
	$args['tax_query'] = array(
		array(
			'taxonomy' 			=> 'turio-package-destination',
			'field' 			=> 'term_id',
			'terms' 			=> $settings['package_destination']
		)
	);

	$packageQuery = new \WP_Query($args);
	
	?>

    <!-- Content One -->
    <?php if ( $settings['turio_package_destination_select'] == 'style_one') : ?>

        <div class="package-area">
            <div class="row g-4">
                <?php
                    if ($packageQuery->have_posts()) :
                        $num = 0;
                        while ($packageQuery->have_posts()) :
                        $num++;
                            $packageQuery->the_post();
                            $package_info = get_post_meta(get_the_ID(), 'turio_turio_package_info_options', true);
                    ?>
						<?php if( $settings['turio_package_destination_column_section'] == 'column_two' ) : ?>
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
						<?php elseif ($settings['turio_package_destination_column_section'] == 'column_three') : ?>
							<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
						<?php elseif ($settings['turio_package_destination_column_section'] == 'column_four') : ?>
							<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
						<?php endif ?>
							<div class="package-card-alpha wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
								<div class="package-thumb">
									<a href="<?php the_permalink(); ?>">
										<?php if (has_post_thumbnail()) : ?>
											<?php the_post_thumbnail('package-card'); ?>
										<?php endif; ?>
									</a>
									<?php if (!empty($settings['turio_package_by_destination_duration_switcher']) && $settings['turio_package_by_destination_duration_switcher'] == 'yes'): ?>
										<p class="card-lavel">
											<?php if (!empty($settings['turio_package_by_destination_duration_icon_switcher']) && $settings['turio_package_by_destination_duration_icon_switcher'] == 'yes'): ?>
												<i class="bi bi-clock"></i> 
											<?php endif ?>
											<?php if (!empty($package_info['tp_duration'])): ?>
												<span><?php esc_html_e($package_info['tp_duration'],'turio-core'); ?></span>
											<?php endif ?>
										</p>
									<?php endif ?>
								</div>
								<div class="package-card-body <?php if(!($settings['turio_package_by_destination_duration_switcher'] == 'yes')) { echo 'pt-2';} ?>">
									<?php if (!empty(get_the_title())): ?>
										<h3 class="p-card-title">
											<a href="<?php the_permalink(); ?>">
												<?php echo esc_html__(substr(get_the_title(),'0','55'),'turio-core'); ?>
											</a>
										</h3>
									<?php endif ?>
									<h6 class="destination-address">
										<i class="bi bi-geo-alt"></i> 
										<?php 
											$destination = get_the_terms(get_the_ID( ), 'turio-package-destination');
											$count = 1;
											if(!empty($destination)){
												foreach($destination as $des) :
													echo sprintf( esc_html__("%s",'turio-core'), $des->name );
													if($count != count($destination)){
														echo ", ";
													}
													$count++;
												endforeach;
											}
										?>
									</h6>
									<div class="p-card-bottom">
										<?php if (!empty($settings['turio_package_by_destination_button_text'])): ?>
											<div class="book-btn">
												<a href="<?php the_permalink(); ?>">
												<?php if (!empty($settings['turio_package_by_destination_button_text'])): ?>
													<?php esc_html_e($settings['turio_package_by_destination_button_text'],'turio-core'); ?>
												<?php endif ?>
													<?php if (!empty($settings['turio_package_by_destination_button_icon_switcher']) && $settings['turio_package_by_destination_button_icon_switcher'] == 'yes'): ?>
														<i class='bx bxs-right-arrow-alt'></i>
													<?php endif ?>
												</a>
											</div>
										<?php endif ?>

										<div class="p-card-info">
											<?php if (!empty($package_info['tp_range_price'])) : ?>
												<span><?php esc_html_e($package_info['tp_range_price'], 'turio-core'); ?></span>
											<?php endif ?>
											<h6>
												<?php
													if( function_exists('turio_get_package_price')) {
														turio_get_package_price();
													}
												?>
											</h6>
										</div>
									</div>
								</div>
							</div>
						</div>
                    <?php
                    endwhile;
                endif;
                ?>
            </div>
        </div>

    <?php endif; ?>

	



    <!-- Content Two -->
    <?php if ( $settings['turio_package_destination_select'] == 'style_two') : ?>

        <div class="package-section">
            <div class="container">
                <div class="row justify-content-center g-4">

                <?php
                    if ($packageQuery->have_posts()) :
                        $num = 0;
                        while ($packageQuery->have_posts()) :
                        $num++;
                            $packageQuery->the_post();
                            $package_info = get_post_meta(get_the_ID(), 'turio_turio_package_info_options', true);
                	?>
                    <?php if( $settings['turio_package_destination_column_section'] == 'column_two' ) : ?>
						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
					<?php elseif ($settings['turio_package_destination_column_section'] == 'column_three') : ?>
						<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
					<?php elseif ($settings['turio_package_destination_column_section'] == 'column_four') : ?>
						<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
					<?php endif ?>
                        <div class="package-delta wow fadeInDown" data-wow-duration="1.5s" data-wow-delay="0.2s">
                            <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail('package-card',array( 'class' => 'package-img' )); ?>
                            <?php endif; ?>
                            <div class="package-badge"> 
								<?php
									if( function_exists('turio_get_package_price')) {
										turio_get_package_price();
									}
								?>
							</div>
                            <div class="text">
                                <?php if (!empty(get_the_title())): ?>
                                    <h4><a href="<?php the_permalink(); ?>"><?php echo esc_html__(substr(get_the_title(),'0','55'),'turio-core'); ?></a></h4>
                                <?php endif;?> 

                                <?php if (!empty($settings['turio_package_by_destination_duration_switcher']) && $settings['turio_package_by_destination_duration_switcher'] == 'yes'): ?>

                                <span>
                                    <?php if (!empty($settings['turio_package_by_destination_duration_icon_switcher']) && $settings['turio_package_by_destination_duration_icon_switcher'] == 'yes'): ?>
                                        <i class='bx bx-calendar-alt'></i>
                                    <?php endif;?>  
                                     <?php if (!empty($package_info['tp_duration'])): ?>  
                                        <?php esc_html_e($package_info['tp_duration'],'turio-core'); ?>
                                     <?php endif;?>   
                                </span>

                                <?php endif;?>

                            </div>
                        </div>
                    </div>

                <?php

                    endwhile;
					wp_reset_postdata();
                    endif;
                
                ?>

                </div>
            </div>
        </div>

    <?php endif; ?>    


<?php
	}
}

Plugin::instance()->widgets_manager->register(new TurioPackageByDestinationWidget());
