<?php

//recent post custom widget

class Turio_Recent_Post_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'turio_recent_post',

            // Widget name
            __('Turio Recent Post', 'turio-core'),

            // Widget description
            array('description' => __('Turio Recent Post', 'turio-core'),)
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
?>
    <aside class="blog-widget widget-recent-entries-custom mt-30">
        <div class="widget-title">
            <?php if( !empty( $title ) ): ?>
                <h4><?php echo  esc_attr( __( $title, 'turio-core' ) ); ?></h4>
            <?php endif; ?>
        </div>
        <?php
                $turioRecentPosts = new WP_Query( array(
                    'post_type'           =>'post',
                    'posts_per_page'      => 4,
                    'orderby'             => "asc"
                ) );
            ?>
        <ul class="widget-body">
        <?php
        while ( $turioRecentPosts->have_posts() ) :
            $turioRecentPosts->the_post();
        ?>
            <li class="clearfix">

                <div class="wi">
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( array(90,80),array( 'class' => 'img-fluid' ) ); ?> </a>
                </div>
                <div class="wb"><h6><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h6>
                <div class="wb-info">
                        <span class="post-date"> <i class="bi bi-person-circle"></i> <?php the_author(); ?>  </span>
                        <span class="post-date"> <i class="bi bi-calendar3"></i> <?php echo __( get_the_date( 'dS M Y' ), 'turio-core' ) ; ?></span>
                </div>
                </div>
            </li>
            <?php endwhile; ?>
        </ul>
        <?php wp_reset_query(); ?>
    </aside>
    <?php
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
    ?>
        <!--Title-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
<?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}

if (!function_exists('Turio_Recent_Post_Widget')) {
    function Turio_Recent_Post_Widget()
    {
        register_widget('Turio_Recent_Post_Widget');
    }
    add_action('widgets_init', 'Turio_Recent_Post_Widget');
}
