<?php

//Social Link custom widget

class Turio_Social_Link_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(

            // Base ID of our widget
            'turio_social_link',

            // Widget name
            __('Turio Social Link', 'turio-core'),

            // Widget description
            array('description' => __('Turio Social Link', 'turio-core'),)
        );
    }

    public function widget($args, $instance)
    {
?>
        <!-- Turio Social link -->
        <div class="footer-social-icons">
            <?php if (!empty($instance['title'])) : ?>
                <h5><?php echo  esc_attr(__($instance['title'], 'turio-core')); ?></h5>
            <?php endif; ?>
            <ul class="footer-social-links justify-content-start">
                <?php if (!empty($instance['instagram_url'])) : ?>
                    <li><a href="<?php echo  esc_url($instance['instagram_url']); ?>"><i class="bx bxl-instagram"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['facebook_url'])) : ?>
                    <li><a href="<?php echo  esc_url($instance['facebook_url']); ?>"><i class="bx bxl-facebook"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['twitter_url'])) : ?>
                    <li><a href="<?php echo  esc_url($instance['twitter_url']); ?>"><i class="bx bxl-twitter"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['whatsapp_url'])) : ?>
                    <li><a href="<?php echo  esc_url($instance['whatsapp_url']); ?>"><i class="bx bxl-whatsapp"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['pinterest_url'])) : ?>
                    <li><a href="<?php echo  esc_url($instance['pinterest_url']); ?>"><i class="bx bxl-pinterest-alt"></i></a></li>
                <?php endif; ?>
            </ul>
        </div>
        <!-- turio Social Link end -->
    <?php
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        $instagram_url = '';
        if (isset($instance['instagram_url'])) {
            $instagram_url = $instance['instagram_url'];
        }
        $facebook_url = '';
        if (isset($instance['facebook_url'])) {
            $facebook_url = $instance['facebook_url'];
        }
        $twitter_url = '';
        if (isset($instance['twitter_url'])) {
            $twitter_url = $instance['twitter_url'];
        }
        $whatsapp_url = '';
        if (isset($instance['whatsapp_url'])) {
            $whatsapp_url = $instance['whatsapp_url'];
        }
        $pinterest_url = '';
        if (isset($instance['pinterest_url'])) {
            $pinterest_url = $instance['pinterest_url'];
        }
    ?>


        <!--Title Start-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('instagram_url'); ?>"><?php _e('Instagram Url:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('instagram_url'); ?>" name="<?php echo $this->get_field_name('instagram_url'); ?>" type="text" value="<?php echo esc_attr($instagram_url); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('facebook_url'); ?>"><?php _e('Facebook Url:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('facebook_url'); ?>" name="<?php echo $this->get_field_name('facebook_url'); ?>" type="text" value="<?php echo esc_attr($facebook_url); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('twitter_url'); ?>"><?php _e('Twitter Url:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('twitter_url'); ?>" name="<?php echo $this->get_field_name('twitter_url'); ?>" type="text" value="<?php echo esc_attr($twitter_url); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('whatsapp_url'); ?>"><?php _e('Whatsapp Url:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('whatsapp_url'); ?>" name="<?php echo $this->get_field_name('whatsapp_url'); ?>" type="text" value="<?php echo esc_attr($whatsapp_url); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('pinterest_url'); ?>"><?php _e('Pinterest Url:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('pinterest_url'); ?>" name="<?php echo $this->get_field_name('pinterest_url'); ?>" type="text" value="<?php echo esc_attr($pinterest_url); ?>" />
        </p>
        <!-- Title end -->



<?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['instagram_url'] = (!empty($new_instance['instagram_url'])) ? strip_tags($new_instance['instagram_url']) : '';
        $instance['facebook_url'] = (!empty($new_instance['facebook_url'])) ? strip_tags($new_instance['facebook_url']) : '';
        $instance['twitter_url'] = (!empty($new_instance['twitter_url'])) ? strip_tags($new_instance['twitter_url']) : '';
        $instance['whatsapp_url'] = (!empty($new_instance['whatsapp_url'])) ? strip_tags($new_instance['whatsapp_url']) : '';
        $instance['pinterest_url'] = (!empty($new_instance['pinterest_url'])) ? strip_tags($new_instance['pinterest_url']) : '';
        return $instance;
    }
}
if (!function_exists('Turio_Social_Link_Widget')) {
    function Turio_Social_Link_Widget()
    {
        register_widget('Turio_Social_Link_Widget');
    }
    add_action('widgets_init', 'Turio_Social_Link_Widget');
}
