{# twig vars #}{##}
{% set titleElem %}<{{title_html_tag}}  class="card_carousel_title">{{item.title|raw}}</{{title_html_tag}}>{% endset %}

{% set linkTitleElem %}
  {% if title_link == "true" %}
  <a href="{{item.link|raw}}" {{item.link_html_attributes|raw}}>{{titleElem}}</a>
  {% else %}
  {{titleElem}}
  {% endif %}
{% endset %}{# end linkTitleElem #}{##}

{% set buttonText %}{% if item.btn_text|raw is empty %}{{button_text|raw}}{% else %}{{item.btn_text|raw}}{% endif %}{% endset %}
{# end twig vars #}{##}

<div id="{{item.item_id}}" class="uc_classic_carousel_container_holder ue-item {{item.item_repeater_class}}" data-hide-item="{{item.hide_item}}">  
  <div class="ue-carousel-item">
    
    {% if show_top_decoration == "true" %}<span class="uc_classic_carousel_border" style=""></span>{% endif %}
    
    {% if show_title == "above_image" %}{{linkTitleElem}}{% endif %}

    {% if show_image == "true" %}
      <div class="uc_classic_carousel_placeholder">
        {% if image_link == "true" %}<a href="{{item.link|raw}}" title="{{item.btn_text}}" {{item.link_html_attributes|raw}}>{% endif %}
          <img src="{{item.image}}" {{item.image_attributes|raw}}>
        {% if image_link == "true" %}</a>{% endif %}
        {% if enable_img_overlay == "true" %}<div class="ue_card_carousel_image_overlay"></div>{% endif %}
      </div>
    {% endif %}

    <div class="uc_classic_carousel_content" style="direction:{{direction}};">    

      {% if show_icon == "true" %}
        <div class="ue-item-icon-wrapper">
           <div class="ue-item-icon">{{item.icon_html|raw}}</div>
        </div>
      {% endif %}

      {% if show_title == "above_content" %}{{linkTitleElem}}{% endif %}
      {% if show_text == "true" %}<p class="card_carousel_text">{{item.content|raw}}</p>{% endif %}
      {% if show_title == "under_content" %}{{linkTitleElem}}{% endif %}	

      {% if show_button == "true" %}
        <div class="ue_button">
          <a class="uc_more_btn {{button_hover_animation}}" href="{{item.link|raw}}" title="{{item.btn_text}}" {{item.link_html_attributes|raw}}>{{buttonText}}</a>
      	</div>   
      {% endif %}	
      
    </div>
    
  </div>
</div>