<?php namespace VEZACONSLTPLUGIN\Element;

class Elementor {
	static $widgets = array(
		'slider_v1',
		'slider_v2',
		'features',
		'about_us_v1',
		'services_v1',
		'apply_immigration_v1',
		'testimonials',
		'immigration_training',
		'call_to_action',
		'recent_blog_v1',
		'partners',
		'apply_immigration_v2',
		'about_us_v2',
		'services_v2',
		'our_agents_v1',
		'exerienced_agents',
		'apply_online_visa',
		'google_map',
		'recent_blog_v2',
		'about_us_v3',
		'our_agents_v2',
		'our_agent_details',
		'coaching',
		'coaching_details',
		'services_v3',
		'service_details',
		'country',
		'country_details',
		'contact_us',
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = VEZACONSLTPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\VEZACONSLTPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'vezaconslt',
			[
				'title' => esc_html__( 'Vezaconslt', 'vezaconslt' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Template Path', 'vezaconslt' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();