<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Recent_Blog_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_recent_blog_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Recent Blog V2', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  2.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'recent_blog_v2',
            [
                'label' => esc_html__( 'Recent Blog V2', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button URL', 'vezaconslt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vezaconslt' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 14,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vezaconslt' ),
                    'title'      => esc_html__( 'Title', 'vezaconslt' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vezaconslt' ),
                    'rand'       => esc_html__( 'Random', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vezaconslt' ),
                    'ASC'  => esc_html__( 'ASC', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'vezaconslt'),
                'options' => get_categories_list(),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = vezaconslt_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-vezaconslt' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => vezaconslt_set( $settings, 'query_number' ),
            'orderby'        => vezaconslt_set( $settings, 'query_orderby' ),
            'order'          => vezaconslt_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( vezaconslt_set( $settings, 'query_category' ) ) $args['category_name'] = vezaconslt_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
        $i=1;
        if ( $query->have_posts() ) { ?>
        
        <!-- news-section -->
        <section class="news-section p_relative sec-pad">
            <div class="auto-container">
                <div class="upper-box p_relative mb_45">
                    <div class="row clearfix">
                        <div class="col-lg-5 col-md-12 col-sm-12 title-column">
                            <div class="sec-title p_relative d_block mt_6">
                                <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12 text-column">
                            <div class="text pr_15">
                                <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12 btn-column">
                        	<?php if($settings['btn_link']['url'] and $settings['btn_title']) { ?>
                            <div class="btn-box text-right mt_30">
                                <a href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>" class="theme-btn btn-two"><?php echo wp_kses( $settings['btn_title'], true ); ?></a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="row clearfix">
                    <?php $i=1; while ( $query->have_posts() ) : $query->the_post();
					if($i<=2) { ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 news-block">
                        <div class="news-block-one wow fadeInUp animated" data-wow-delay="400ms" data-wow-duration="1500ms">
                            <div class="inner-box p_relative d_block b_radius_10 tran_5">
                                <div class="image-box p_relative d_block">
                                    <figure class="image p_relative d_block">
                                        <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><i class="fas fa-link"></i></a>
                                        <?php the_post_thumbnail('vezaconslt_370x215'); ?>
                                    </figure>
                                    <span class="post-date p_absolute r_30 b_0 w_120 fs_12 color-white fw_sbold z_1"><?php echo get_the_date(); ?></span>
                                </div>
                                <div class="lower-content p_relative d_block pt_25 pr_30 pb_30 pl_30">
                                    <h3 class="d_block fs_22 lh_30 mb_5"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="d_iblock black-color hov-color"><?php the_title(); ?></a></h3>
                                    <ul class="post-info clearfix p_relative d_block tran_5">
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium mr_25"><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>" class="d_iblock hov-color"><?php esc_html_e('By', 'vezaconslt'); ?> <?php the_author(); ?></a></li>
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>" class="d_iblock hov-color"><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                                    </ul>
                                    <div class="link p_absolute l_30 b_30"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="p_relative d_iblock fs_14 fw_medium theme-color"><?php esc_html_e('Read More', 'vezaconslt'); ?></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } $i++; endwhile; ?>
                    
                    <div class="col-lg-4 col-md-6 col-sm-12 news-block">
                        <?php $i=1; while ( $query->have_posts() ) : $query->the_post();
						if($i>2) { ?>
                        <div class="news-block-two wow fadeInUp animated" data-wow-delay="300ms" data-wow-duration="1500ms">
                            <div class="inner-box p_relative d_block b_radius_10 tran_5 bg-color-2 mb_30">
                                <div class="lower-content p_relative d_block pt_35 pr_30 pb_35 pl_30">
                                    <h3 class="d_block fs_22 lh_30 mb_5"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="d_iblock black-color hov-color"><?php the_title(); ?></a></h3>
                                    <ul class="post-info clearfix p_relative d_block tran_5">
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium mr_25"><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>" class="d_iblock hov-color"><?php esc_html_e('By', 'vezaconslt'); ?> <?php the_author(); ?></a></li>
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>" class="d_iblock hov-color"><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php } $i++; endwhile; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- news-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
