<?php
/**
 * Archive Main File.
 *
 * @package VEZACONSLT
 * @author  Template Path
 * @version 1.0
 */
get_header();
global $wp_query;
$data  = \VEZACONSLT\Includes\Classes\Common::instance()->data( 'archive' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>

<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'vezaconslt_banner', $data );?>
<?php else:?>
<!-- Page Title -->
<section class="page-title p_relative" style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box p_relative pt_170 pb_170">
            <h1 class="d_block fs_40 lh_50 color_white fw_exbold color-white"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            <ul class="bread-crumb p_absolute r_0 b_0 d_iblock pl_30 pr_30 bg-white clearfix pt_4 pb_4">
            	<?php echo vezaconslt_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->
<?php endif;?>

<!-- sidebar-page-container -->
<section class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'vezaconslt_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
                <div class="blog-classic-content">
                    <div class="thm-unit-test">
                    
                        <?php
                            while ( have_posts() ) :
                                the_post();
                                vezaconslt_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                            endwhile;
                            wp_reset_postdata();
                        ?>
                        
                    </div>
                
                    <!--Pagination-->
					<div class="row">
						<div class="col-xl-12">
							<?php vezaconslt_the_pagination( $wp_query->max_num_pages );?>
						</div>
					</div>
            	</div> 
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'vezaconslt_sidebar', $data );
				}
			?>
        </div>
    </div>
</div> 
<!--End blog area--> 
<?php
}
get_footer();
