<?php

return array(
	'title'      => esc_html__( '404 Page Settings', 'vezaconslt' ),
	'id'         => '404_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => '404_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( '404 Source Type', 'vezaconslt' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'vezaconslt' ),
				'e' => esc_html__( 'Elementor', 'vezaconslt' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => '404_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'vezaconslt' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
			],
			'required' => [ '404_source_type', '=', 'e' ],
		),
		array(
			'id'       => '404_default_st',
			'type'     => 'section',
			'title'    => esc_html__( '404 Default', 'vezaconslt' ),
			'indent'   => true,
			'required' => [ '404_source_type', '=', 'd' ],
		),
		//404 Banner
		array(
			'id'      => '404_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'vezaconslt' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'vezaconslt' ),
			'default' => true,
		),
		array(
			'id'       => '404_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'vezaconslt' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'vezaconslt' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'       => '404_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'vezaconslt' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'vezaconslt' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		
		//404 Content
		array(
			'id'    => 'error_404',
			'type'  => 'text',
			'title' => esc_html__( '404 Title', 'vezaconslt' ),
			'desc'  => esc_html__( 'Enter 404 title that you want to show.', 'vezaconslt' ),
		),
		array(
			'id'    => 'error_text',
			'type'  => 'text',
			'title' => esc_html__( '404 Text', 'vezaconslt' ),
			'desc'  => esc_html__( 'Enter 404 text that you want to show.', 'vezaconslt' ),
		),
		array(
			'id'    => 'error_description',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Description', 'vezaconslt' ),
			'desc'  => esc_html__( 'Enter 404 page description that you want to show.', 'vezaconslt' ),
		),
		
		//Button
		array(
			'id'    => 'back_to_home_btn',
			'type'  => 'switch',
			'title' => esc_html__( 'Show Button', 'vezaconslt' ),
			'desc'  => esc_html__( 'Enable to show back to home button.', 'vezaconslt' ),
			'default'  => true,
		),
		array(
			'id'       => 'back_home_btn_label',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Label', 'vezaconslt' ),
			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'vezaconslt' ),
			'default'  => esc_html__( 'Go Home', 'vezaconslt' ),
			'required' => array( 'back_to_home_btn', '=', true ),
		),
		array(
			'id'     => '404_post_settings_end',
			'type'   => 'section',
			'indent' => false,
		),
	),
);
