<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'vezaconslt' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'vezaconslt' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'vezaconslt' ),
				'e' => esc_html__( 'Elementor', 'vezaconslt' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'vezaconslt' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'vezaconslt' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'vezaconslt' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'vezaconslt' ),
		    'options'  => array(

			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style 1', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',
			    ),
			    'footer_v2'  => array(
				    'alt' => esc_html__( 'Footer Style 2', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer2.png',
			    ),
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v1',
	    ),
		
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'vezaconslt' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		
		//Footer Top Bar
		array(
		    'id'       => 'show_footer_top_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Top Bar', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Top Bar.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
	    ),
		
		//Footer Background
		array(
			'id'       => 'footer_background_image_v1',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Background Image', 'vezaconslt' ),
			'default'  => array(
			    'url' => VEZACONSLT_URI . 'assets/images/shape/shape-5.png',
		    ),
			'required' => array( 'show_footer_top_v1', '=', true ),
		),
		
		//Email Address
		array(
		    'id'       => 'show_footer_email_address_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Email Address', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Email Address.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_footer_top_v1', '=', true ),
	    ),
		array(
		    'id'       => 'footer_email_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Title', 'vezaconslt' ),
			'required' => array( 'show_footer_email_address_v1', '=', true ),
		),
		array(
		    'id'       => 'footer_email_address_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'vezaconslt' ),
			'required' => array( 'show_footer_email_address_v1', '=', true ),
		),
		
		//Footer Logo
		array(
            'id' => 'show_footer_logo_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Footer Logo', 'vezaconslt'),
            'default' => true,
			'required' => array( 'show_footer_top_v1', '=', true ),
        ),
		array(
			'id'       => 'footer_logo_v1',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Logo', 'vezaconslt' ),
			'subtitle' => esc_html__( 'Insert site Footer logo image', 'vezaconslt' ),
			'required' => array( 'show_footer_logo_v1', '=', true ),
		),
		array(
			'id'       => 'footer_logo_v1_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Light Logo Dimension', 'vezaconslt' ),
			'subtitle' => esc_html__( 'Select Light Logo Dimension', 'vezaconslt' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'show_footer_logo_v1', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'show_footer_phone_number_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_footer_top_v1', '=', true ),
	    ),
		array(
		    'id'       => 'footer_phone_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Title', 'vezaconslt' ),
			'required' => array( 'show_footer_phone_number_v1', '=', true ),
		),
		array(
		    'id'       => 'footer_phone_number_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_footer_phone_number_v1', '=', true ),
		),
		
		//Copyrights
		array(
			'id'      => 'copyright_text',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'vezaconslt' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		
		/***********************************************************************
								Footer Version 2 Start
		************************************************************************/
		array(
			'id'       => 'footer_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Two Settings', 'vezaconslt' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		
		//Footer Contact Info
		array(
		    'id'       => 'show_footer_contact_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Contact', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Top Menu.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
	    ),
		
		//Address
		array(
		    'id'       => 'show_footer_address_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Address', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Address.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_footer_contact_v2', '=', true ),
	    ),
		array(
		    'id'       => 'footer_address_v2',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Address', 'vezaconslt' ),
			'required' => array( 'show_footer_address_v2', '=', true ),
		),
		
		//Email Address
		array(
		    'id'       => 'show_footer_email_address_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Email Address', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Email Address.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_footer_contact_v2', '=', true ),
	    ),
		array(
		    'id'       => 'footer_email_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Title', 'vezaconslt' ),
			'required' => array( 'show_footer_email_address_v2', '=', true ),
		),
		array(
		    'id'       => 'footer_email_address_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'vezaconslt' ),
			'required' => array( 'show_footer_email_address_v2', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'show_footer_phone_number_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_footer_contact_v2', '=', true ),
	    ),
		array(
		    'id'       => 'footer_phone_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Title', 'vezaconslt' ),
			'required' => array( 'show_footer_phone_number_v2', '=', true ),
		),
		array(
		    'id'       => 'footer_phone_number_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_footer_phone_number_v2', '=', true ),
		),
		
		//Footer Background
		array(
			'id'       => 'footer_background_v2',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Footer Background Image', 'vezaconslt' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		
		//Copyrights
		array(
			'id'      => 'copyright_text2',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'vezaconslt' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
