<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'vezaconslt' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'vezaconslt' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'vezaconslt' ),
				'e' => esc_html__( 'Elementor', 'vezaconslt' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'vezaconslt' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'vezaconslt' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),

		//Header Settings
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'vezaconslt' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'vezaconslt' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Boxed Layout', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
			    'header_v3'  => array(
				    'alt' => esc_html__( 'Header OnePage', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header3.png',
			    ),
				'header_v4'  => array(
				    'alt' => esc_html__( 'Header RTL', 'vezaconslt' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header4.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v1',
	    ),

		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'vezaconslt' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		
		//Topbar
		array(
		    'id'       => 'show_top_bar_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Top Bar', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Top Bar.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		
		//Phone Number
		array(
		    'id'       => 'show_phone_number_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'phone_number_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v1', '=', true ),
		),
		
		//Eemail Address
		array(
		    'id'       => 'show_email_address_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Eemail Address', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Eemail Address.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'email_address_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Eemail Address', 'vezaconslt' ),
			'required' => array( 'show_email_address_v1', '=', true ),
		),
		
		//Social Media
		array(
		    'id'       => 'show_social_media_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Mobile Sidebar Social Media', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_top_bar_v1', '=', true ),
	    ),
		array(
			'id'    => 'social_media_v1',
			'type'  => 'social_media',
			'title' => esc_html__( 'Mobile Sidebar Social Media', 'vezaconslt' ),
			'required' => array( 'show_social_media_v1', '=', true ),
		),
		
		//Button
		array(
		    'id'       => 'show_button_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Button.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_top_bar_v1', '=', true ),
	    ),
		array(
		    'id'       => 'btn_name_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Name', 'vezaconslt' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		array(
		    'id'       => 'btn_link_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'vezaconslt' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		
		//Search
		array(
		    'id'       => 'show_search_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Search.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		/***********************************************************************
								Mobile Info V1
		************************************************************************/
		array(
            'id' => 'show_mobile_sidebar_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Mobile Information', 'kanstr'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		
		//Contact Title
		array(
		    'id'       => 'mobile_contact_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Title', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v1', '=', true ),
	    ),
		
		//Address
		array(
		    'id'       => 'mobile_address_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'kanstr' ),
			'required' => array( 'show_mobile_sidebar_v1', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'mobile_phone_number_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v1', '=', true ),
	    ),
		
		//Email Address
		array(
		    'id'       => 'mobile_email_address_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v1', '=', true ),
	    ),
		
		//Social Media
		array(
		    'id'       => 'show_mobile_social_media_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Media', 'kanstr' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'kanstr' ),
			'default'  => '',
			'required' => array( 'show_mobile_sidebar_v1', '=', true ),
	    ),
		array(
			'id'    => 'mobile_social_media_v1',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Media', 'kanstr' ),
			'required' => array( 'show_mobile_social_media_v1', '=', true ),
		),
		
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'vezaconslt' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		
		//Phone Number
		array(
		    'id'       => 'show_phone_number_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'phone_text_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Text', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v2', '=', true ),
		),
		array(
		    'id'       => 'phone_number_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v2', '=', true ),
		),
		
		//Search
		array(
		    'id'       => 'show_search_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Search.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		/***********************************************************************
								Mobile Info V2
		************************************************************************/
		array(
            'id' => 'show_mobile_sidebar_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable Mobile Information', 'kanstr'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		
		//Contact Title
		array(
		    'id'       => 'mobile_contact_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Title', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v2', '=', true ),
	    ),
		
		//Address
		array(
		    'id'       => 'mobile_address_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'kanstr' ),
			'required' => array( 'show_mobile_sidebar_v2', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'mobile_phone_number_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v2', '=', true ),
	    ),
		
		//Email Address
		array(
		    'id'       => 'mobile_email_address_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v2', '=', true ),
	    ),
		
		//Social Media
		array(
		    'id'       => 'show_mobile_social_media_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Media', 'kanstr' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'kanstr' ),
			'default'  => '',
			'required' => array( 'show_mobile_sidebar_v2', '=', true ),
	    ),
		array(
			'id'    => 'mobile_social_media_v2',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Media', 'kanstr' ),
			'required' => array( 'show_mobile_social_media_v2', '=', true ),
		),
		
        /***********************************************************************
								Header Version 3 Start
		************************************************************************/
		array(
			'id'       => 'header_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Three Settings', 'vezaconslt' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		
		//Phone Number
		array(
		    'id'       => 'show_phone_number_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		array(
		    'id'       => 'phone_text_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Text', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v3', '=', true ),
		),
		array(
		    'id'       => 'phone_number_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v3', '=', true ),
		),
		
		//Search
		array(
		    'id'       => 'show_search_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Search.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		/***********************************************************************
								Mobile Info V3
		************************************************************************/
		array(
            'id' => 'show_mobile_sidebar_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable Mobile Information', 'kanstr'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		
		//Contact Title
		array(
		    'id'       => 'mobile_contact_title_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Title', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v3', '=', true ),
	    ),
		
		//Address
		array(
		    'id'       => 'mobile_address_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'kanstr' ),
			'required' => array( 'show_mobile_sidebar_v3', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'mobile_phone_number_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v3', '=', true ),
	    ),
		
		//Email Address
		array(
		    'id'       => 'mobile_email_address_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v3', '=', true ),
	    ),
		
		//Social Media
		array(
		    'id'       => 'show_mobile_social_media_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Media', 'kanstr' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'kanstr' ),
			'default'  => '',
			'required' => array( 'show_mobile_sidebar_v3', '=', true ),
	    ),
		array(
			'id'    => 'mobile_social_media_v3',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Media', 'kanstr' ),
			'required' => array( 'show_mobile_social_media_v3', '=', true ),
		),
		
		/***********************************************************************
								Header Version 4 Start
		************************************************************************/
		array(
			'id'       => 'header_v4_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Four Settings', 'vezaconslt' ),
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
		),
		
		//Topbar
		array(
		    'id'       => 'show_top_bar_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Top Bar', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Top Bar.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		
		//Phone Number
		array(
		    'id'       => 'show_phone_number_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Phone Number.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		array(
		    'id'       => 'phone_number_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'vezaconslt' ),
			'required' => array( 'show_phone_number_v4', '=', true ),
		),
		
		//Eemail Address
		array(
		    'id'       => 'show_email_address_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Eemail Address', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Eemail Address.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		array(
		    'id'       => 'email_address_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Eemail Address', 'vezaconslt' ),
			'required' => array( 'show_email_address_v4', '=', true ),
		),
		
		//Social Media
		array(
		    'id'       => 'show_social_media_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Mobile Sidebar Social Media', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_top_bar_v4', '=', true ),
	    ),
		array(
			'id'    => 'social_media_v4',
			'type'  => 'social_media',
			'title' => esc_html__( 'Mobile Sidebar Social Media', 'vezaconslt' ),
			'required' => array( 'show_social_media_v4', '=', true ),
		),
		
		//Button
		array(
		    'id'       => 'show_button_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Button.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'show_top_bar_v4', '=', true ),
	    ),
		array(
		    'id'       => 'btn_name_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Name', 'vezaconslt' ),
			'required' => array( 'show_button_v4', '=', true ),
		),
		array(
		    'id'       => 'btn_link_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'vezaconslt' ),
			'required' => array( 'show_button_v4', '=', true ),
		),
		
		//Search
		array(
		    'id'       => 'show_search_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search', 'vezaconslt' ),
		    'desc'     => esc_html__( 'Enable/Disable Search.', 'vezaconslt' ),
			'default'  => '',
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		/***********************************************************************
								Mobile Info V4
		************************************************************************/
		array(
            'id' => 'show_mobile_sidebar_v4',
            'type' => 'switch',
            'title' => esc_html__('Enable Mobile Information', 'kanstr'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
        ),
		
		//Contact Title
		array(
		    'id'       => 'mobile_contact_title_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Title', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v4', '=', true ),
	    ),
		
		//Address
		array(
		    'id'       => 'mobile_address_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'kanstr' ),
			'required' => array( 'show_mobile_sidebar_v4', '=', true ),
		),
		
		//Phone Number
		array(
		    'id'       => 'mobile_phone_number_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v4', '=', true ),
	    ),
		
		//Email Address
		array(
		    'id'       => 'mobile_email_address_v4',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'kanstr' ),
			'default'  => '',
		    'required' => array( 'show_mobile_sidebar_v4', '=', true ),
	    ),
		
		//Social Media
		array(
		    'id'       => 'show_mobile_social_media_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Media', 'kanstr' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'kanstr' ),
			'default'  => '',
			'required' => array( 'show_mobile_sidebar_v4', '=', true ),
	    ),
		array(
			'id'    => 'mobile_social_media_v4',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Media', 'kanstr' ),
			'required' => array( 'show_mobile_social_media_v4', '=', true ),
		),
		
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
