<?php
/**
 * Blog Post Main File.
 *
 * @package VEZACONSLT
 * @author  Template Path
 * @version 1.0
 */

get_header();
$data    = \VEZACONSLT\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-lg-12 col-md-12 col-sm-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = vezaconslt_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else { ?>

<!-- Page Title -->
<section class="page-title p_relative" style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box p_relative pt_170 pb_170">
            <h1 class="d_block fs_40 lh_50 color_white fw_exbold color-white"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            <ul class="bread-crumb p_absolute r_0 b_0 d_iblock pl_30 pr_30 bg-white clearfix pt_4 pb_4">
            	<?php echo vezaconslt_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<!-- sidebar-page-container -->
<section class="coaching-details p_relative pt_120 pb_120">
    <div class="auto-container">
        <div class="row clearfix">
        	
            <?php if( $data->get( 'layout' ) == 'left' ): ?>
            <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side"> 
                <div class="coaching-sidebar p_relative d_block">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </div>
            </div>
            <?php endif;?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	
				<?php while ( have_posts() ) : the_post(); ?>
                <div class="thm-unit-test">
					
					<div class="coaching-details-content p_relative d_block">
                        
                        <div class="content-one p_relative d_block mb_55">
                            <figure class="image-box p_relative d_block b_radius_10 mb_30"><?php the_post_thumbnail('vezaconslt_770x410'); ?></figure>
                        </div>
                        <div class="text">
                        	<?php the_content(); ?>
                        </div>
                    </div>
                    
                </div>
                <?php endwhile; ?>
                
            </div>
        	<?php if( $data->get( 'layout' ) == 'right' ): ?>
            <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side"> 
                <div class="coaching-sidebar p_relative d_block">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </div>
            </div>
            <?php endif;?>
        </div>
    </div>
</section>
<!--End blog area--> 

<?php
}
get_footer();
