<?php
/**
 * Blog Post Main File.
 *
 * @package VEZACONSLT
 * @author  Template Path
 * @version 1.0
 */

get_header();
$data    = \VEZACONSLT\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-lg-12 col-md-12 col-sm-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = vezaconslt_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else { ?>

<!-- Page Title -->
<section class="page-title p_relative" style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box p_relative pt_170 pb_170">
            <h1 class="d_block fs_40 lh_50 color_white fw_exbold color-white"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            <ul class="bread-crumb p_absolute r_0 b_0 d_iblock pl_30 pr_30 bg-white clearfix pt_4 pb_4">
            	<?php echo vezaconslt_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<!-- sidebar-page-container -->
<section class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'vezaconslt_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	
				<?php while ( have_posts() ) : the_post(); ?>
                <div class="thm-unit-test">
					
					<div class="blog-details-content">
                        <div class="news-block-one">
                            <div class="inner-box p_relative d_block b_radius_10 tran_5">
                                <div class="image-box p_relative d_block">
                                    <figure class="image p_relative d_block">
                                        <?php the_post_thumbnail('vezaconslt_770x410'); ?>
                                    </figure>
                                    <span class="post-date p_absolute r_30 b_0 w_120 fs_12 color-white fw_sbold z_1"><?php echo get_the_date(); ?></span>
                                </div>
                                <div class="lower-content p_relative d_block pt_25 pr_30 pb_30 pl_30">
                                    <ul class="post-info clearfix p_relative d_block tran_5">
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium mr_25"><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) )); ?>" class="d_iblock hov-color"><?php esc_html_e('By', 'vezaconslt'); ?> <?php the_author(); ?></a></li>
                                        <li class="p_relative d_iblock float_left fs_14 fw_medium"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>" class="d_iblock hov-color"><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                                    </ul>
                                    <?php the_content(); ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($options->get( 'single_post_tag' ) or $options->get( 'single_post_share_us' )){ ?>
                        <div class="post-share-option clearfix">
                        	<?php if( $options->get( 'single_post_tag' ) ): ?>
                            <ul class="tags-list clearfix pull-left">
                            	<li><h5><?php esc_html_e('Tags', 'vezaconslt'); ?></h5></li>
                                <?php the_tags( '<li>', '</li><li> ', '</li>' ); ?>
                            </ul>
                            <?php endif; ?>
                            
                            <?php if( $options->get( 'single_post_share_us' ) ): ?>
							<?php echo wp_kses(vezaconslt_share_us(get_the_id(), $post->post_name ), true); ?>
                            <?php endif; ?>
                        </div>
                        <?php } ?>
                        
                        <?php if( $options->get( 'single_post_author_box' ) ): ?>
                        <div class="author-box">
                            <figure class="image-box"><?php echo get_avatar(get_the_author_meta('ID'), 160); ?></figure>
                            <div class="inner">
                                <h3><?php the_author(); ?></h3>
                                <p><?php the_author_meta( 'description', get_the_author_meta('ID') ); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Comments Area -->
						<?php comments_template(); ?>
                    </div>
                    
                </div>
                <?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'vezaconslt_sidebar', $data );
				}
			?>
        </div>
    </div>
</section>
<!--End blog area--> 

<?php
}
get_footer();
