<?php
$options = vezaconslt_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Logo
$light_logo = $options->get( 'light_logo' );
$light_logo_dimension = $options->get( 'light_logo_dimension' );

//Dark Logo
$dark_logo = $options->get( 'dark_logo' );
$dark_logo_dimension = $options->get( 'dark_logo_dimension' );

//Mobile Logo
$mobile_logo = $options->get( 'mobile_sidebar_logo' );
$mobile_logo_dimension = $options->get( 'mobile_sidebar_logo_dimension' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

<div class="boxed_wrapper">

	<?php if( $options->get( 'theme_preloader' ) ):?>
	<!-- preloader -->
    <div class="loader-wrap">
        <div class="preloader">
            <div class="preloader-close">x</div>
            <div id="handle-preloader" class="handle-preloader">
                <div class="animation-preloader">
                    <div class="spinner"></div>
                </div>  
            </div>
        </div>
    </div>
    <!-- preloader end -->
	<?php endif; ?>
	
	<!-- main header -->
    <header class="main-header style-two">
        <!-- header-lower -->
        <div class="header-lower">
            <div class="outer-box clearfix">
                <div class="logo-box">
                    <figure class="logo"><?php echo vezaconslt_logo( $logo_type, $light_logo, $light_logo_dimension, $logo_text, $logo_typography ); ?></figure>
                </div>
                <div class="menu-area clearfix">
                    <!--Mobile Navigation Toggler-->
                    <div class="mobile-nav-toggler">
                        <i class="icon-bar"></i>
                        <i class="icon-bar"></i>
                        <i class="icon-bar"></i>
                    </div>
                    <nav class="main-menu navbar-expand-md navbar-light">
                        <div class="collapse navbar-collapse show clearfix" id="navbarSupportedContent">
                            <ul class="navigation scroll-nav clearfix">
                                <?php wp_nav_menu( array( 'theme_location' => 'menu_onepage', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false,
									'items_wrap' => '%3$s',
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker(),
								) ); ?>
                            </ul>
                        </div>
                    </nav>
                    <div class="nav-right clearfix">
                    	<?php if( $options->get('show_phone_number_v3') ) { ?>
                        <div class="info-box">
                            <div class="icon-box"><i class="flaticon-phone-call"></i></div>
                            <span>Call now</span>
                            <h5><a href="tel:<?php echo esc_attr(phone_number($options->get('phone_number_v3'))); ?>"><?php echo wp_kses($options->get('phone_number_v3'), $allowed_html); ?></a></h5>
                        </div>
                        <?php } ?>
                        
                        <?php if( $options->get('show_search_v3') ) { ?>
                        <div class="search-box-outer">
                            <div class="dropdown">
                                <button class="search-box-btn" type="button" id="dropdownMenu3" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="flaticon-magnifying-glass"></i></button>
                                <div class="dropdown-menu search-panel" aria-labelledby="dropdownMenu3">
                                    <div class="form-container">
                                        <?php echo get_template_part('searchform1'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!--sticky Header-->
        <div class="sticky-header">
            <div class="auto-container">
                <div class="outer-box">
                    <div class="outer-box clearfix">
                        <div class="logo-box pull-left">
                            <figure class="logo"><?php echo vezaconslt_logo( $logo_type, $dark_logo, $dark_logo_dimension, $logo_text, $logo_typography ); ?></figure>
                        </div>
                        <div class="menu-area clearfix pull-right">
                            <nav class="main-menu clearfix">
                                <!--Keep This Empty / Menu will come through Javascript-->
                            </nav>
                            <div class="nav-right clearfix">
                            	<?php if( $options->get('show_search_v3') ) { ?>
                                <div class="search-box-outer">
                                    <div class="dropdown">
                                        <button class="search-box-btn" type="button" id="dropdownMenu4" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="flaticon-magnifying-glass"></i></button>
                                        <div class="dropdown-menu search-panel" aria-labelledby="dropdownMenu4">
                                            <div class="form-container">
                                                <?php echo get_template_part('searchform1'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- main-header end -->

	<?php if( $options->get('show_mobile_sidebar_v3') ) { ?>
    <!-- Mobile Menu  -->
    <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><i class="fas fa-times"></i></div>
        
        <nav class="menu-box">
            <div class="nav-logo"><?php echo vezaconslt_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
            <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            <div class="contact-info">
                <h4><?php echo wp_kses($options->get('mobile_contact_title_v3'), $allowed_html); ?></h4>
                <ul>
                	<?php if( $options->get('mobile_address_v3') ) { ?>
                    <li><?php echo wp_kses($options->get('mobile_address_v3'), $allowed_html); ?></li>
                    <?php } ?>
                    
                    <?php if( $options->get('mobile_phone_number_v3') ) { ?>
                    <li><a href="tel:<?php echo esc_attr(phone_number($options->get('mobile_phone_number_v3'))); ?>"><?php echo wp_kses($options->get('mobile_phone_number_v3'), $allowed_html); ?></a></li>
                    <?php } ?>
                    
                    <?php if( $options->get('mobile_email_address_v3') ) { ?>
                    <li><a href="mailto:<?php echo sanitize_email($options->get('mobile_email_address_v3')); ?>"><?php echo sanitize_email($options->get('mobile_email_address_v3')); ?></a></li>
                    <?php } ?>
                </ul>
            </div>
            
            <?php if( $options->get('show_mobile_social_media_v3') ):
			$icons = $options->get( 'mobile_social_media_v3' );
			if ( ! empty( $icons ) ) : ?>
            <div class="social-links">
				<ul class="clearfix">
					<?php foreach ( $icons as $h_icon ) :
					$header_social_icons = json_decode( urldecode( vezaconslt_set( $h_icon, 'data' ) ) );
					if ( vezaconslt_set( $header_social_icons, 'enable' ) == '' ) {
						continue;
					}
					$icon_class = explode( '-', vezaconslt_set( $header_social_icons, 'icon' ) ); ?>
					<li><a href="<?php echo esc_url(vezaconslt_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(vezaconslt_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(vezaconslt_set( $header_social_icons, 'color' )); ?>" target="_blank"><span class="fab <?php echo esc_attr( vezaconslt_set( $header_social_icons, 'icon' ) ); ?>"></span></a></li>
					<?php endforeach; ?>
				</ul>
            </div>
			<?php endif; endif; ?>
        </nav>
    </div>
    <!-- End Mobile Menu -->
    <?php } ?>
	