<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_about_us_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'About Us V2', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  2.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'about_us_v2',
            [
                'label' => esc_html__( 'About Us V2', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'top_image',
            [
                'label' => __( 'Top Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'bottom_image',
            [
                'label' => __( 'Bottom Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'icon_image',
            [
                'label' => __( 'Icon Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'features',
            [
                'label'       => __( 'Features', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'bold_icon',
            [
				'label' => esc_html__('Select Icon', 'vezaconslt'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
        $this->add_control(
            'bold_text',
            [
                'label'       => __( 'Bold Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button URL', 'vezaconslt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vezaconslt' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
		$this->add_control(
            'phone_text',
            [
                'label'       => __( 'Phone Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'phone_number',
            [
                'label'       => __( 'Phone Number', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- about-style-two -->
        <section class="about-style-two p_relative pt_120 pb_120">
            <div class="pattern-layer p_absolute r_20" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/shape/shape-7.png'); ?>);"></div>
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12 image-column">
                        <div class="image-box p_relative mr_30">
                            <figure class="image image-1 p_relative d_block"><img src="<?php echo esc_url(wp_get_attachment_url($settings['top_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                            <figure class="image image-2 p_absolute b_0 wow slideInLeft animated" data-wow-delay="00ms" data-wow-duration="1500ms"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bottom_image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                            
                            <?php if ($settings['icon_image']['id']){ ?>
                            <div class="logo-icon p_absolute w_150 h_150 lh_150 centred theme-color-bg b_radius_50"><img src="<?php echo esc_url(wp_get_attachment_url($settings['icon_image']['id'])); ?>" alt="<?php esc_html_e('Icon Image', 'vezaconslt'); ?>"></div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                        <div class="content_block_2">
                            <div class="content-box p_relative d_block ml_30">
                                <div class="sec-title p_relative d_block mb_40">
                                    <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                </div>
                                <div class="text p_relative d_block mb_30">
                                    <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                                </div>
                                
                                <?php $features_list = $settings['features'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); ?>
                                <ul class="list-style-one clearfix p_relative d_block mb_30">
                                	<?php foreach($features_list as $features): ?>
									<li class="p_relative d_iblock fs_18 lh_25 fw_medium black-color mb_15"><?php echo wp_kses($features, true); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php } ?>
                                
                                <div class="small-title p_relative d_block pl_80 mb_40">
                                    <div class="icon-box p_absolute l_0 t_9 fs_65 theme-color"><i class="<?php echo esc_attr($settings['bold_icon']); ?>"></i></div>
                                    <h3 class="lh_40 fw_exbold"><?php echo wp_kses( $settings['bold_text'], true ); ?></h3>
                                </div>
                                <div class="lower-box clearfix">
                                	<?php if($settings['btn_link']['url'] and $settings['btn_title']) { ?>
                                    <div class="btn-box pull-left mr_20">
                                    	<a href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>" class="theme-btn btn-one"><?php echo wp_kses( $settings['btn_title'], true ); ?></a>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php if($settings['phone_text'] and $settings['phone_number']) { ?>
                                    <div class="info-box p_relative pl_85 pull-left pt_12 pb_6">
                                        <div class="icon-box p_absolute l_0 t_0 w_75 h_75 lh_85 fs_30 theme-color centred b_radius_50"><i class="flaticon-phone-call"></i></div>
                                        <span class="p_relative d_block fs_14 lh_20 mb_3"><?php echo wp_kses( $settings['phone_text'], true ); ?></span>
                                        <h5 class="p_relative d_iblock fs_18 lh_30 fw_medium"><a href="tel:<?php echo esc_attr(phone_number($settings['phone_number'])); ?>" class="d_iblock black-color hov-color"><?php echo wp_kses( $settings['phone_number'], true ); ?></a></h5>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-style-two end -->
        
        <?php
    }
}
