<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Apply_Online_Visa extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_apply_online_visa';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Apply Online Visa', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'apply_online_visa',
            [
                'label' => esc_html__( 'Apply Online Visa', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'Features', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'vezaconslt'),
                            'type' => Controls_Manager::SELECT2,
							'label_block' => true,
                            'options' => get_fontawesome_icons(),
                        ],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- process-section -->
        <section class="process-section p_relative pt_110 pb_110 centred">
            <div class="auto-container">
                <div class="sec-title p_relative d_block mb_60">
                    <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                <div class="row clearfix">
                    <?php $i=1; foreach($settings['slides'] as $key => $item) { ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 processing-block">
                        <div class="processing-block-one wow fadeInUp animated" data-wow-delay="300ms" data-wow-duration="1500ms">
                            <div class="inner-box p_relative d_block">
                                <div class="arrow p_absolute" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/arrow-1.png'); ?>);"></div>
                                <div class="icon-box p_relative d_iblock w_180 h_180 lh_190 centred fs_65 theme-color b_radius_50 mb_13">
                                    <i class="<?php echo esc_attr($item['icon']); ?>"></i>
                                    <span class="p_absolute r_0 b_0 w_65 h_65 lh_55 text-left b_radius_50 fs_16 color-white fw_bold pl_20 pb_20 z_1"><?php echo wp_kses(sprintf('%02d', $i), true); ?></span>
                                </div>
                                <h3 class="d_block fs_24 lh_30 mb_20"><?php echo wp_kses($item['title'], true); ?></h3>
                                <p><?php echo wp_kses($item['text'], true); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php $i++; } ?>
                </div>
            </div>
        </section>
        <!-- process-section end -->
        
        <?php
    }
}
