<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Coaching extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_coaching';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Coaching', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'coaching',
            [
                'label' => esc_html__( 'Coaching', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 19,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vezaconslt' ),
                    'title'      => esc_html__( 'Title', 'vezaconslt' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vezaconslt' ),
                    'rand'       => esc_html__( 'Random', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vezaconslt' ),
                    'ASC'  => esc_html__( 'ASC', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'vezaconslt'),
                'options' => get_categories_list('coaching_cat'),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = vezaconslt_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-vezaconslt' );
        $args = array(
            'post_type'      => 'coaching',
            'posts_per_page' => vezaconslt_set( $settings, 'query_number' ),
            'orderby'        => vezaconslt_set( $settings, 'query_orderby' ),
            'order'          => vezaconslt_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( vezaconslt_set( $settings, 'query_category' ) ) $args['coaching_cat'] = vezaconslt_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- coaching-section -->
        <section class="coaching-section p_relative pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 coaching-block">
                        <div class="coaching-block-one wow fadeInUp animated" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="inner-box p_relative d_block mb_30">
                                <figure class="image-box p_relative d_block b_radius_10"><?php the_post_thumbnail('vezaconslt_370x465'); ?></figure>
                                <div class="text p_absolute pl_50 b_45 z_1 tran_5">
                                    <h3 class="p_relative d_iblock fs_24 lh_30"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="p_relative pt_16 d_iblock color-white hov-color"><?php the_title(); ?></a></h3>
                                </div>
                                <div class="overlay-content p_absolute pl_50 pr_40 z_1 tran_5">
                                    <h3 class="p_relative d_iblock fs_24 lh_30 mb_2"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="p_relative pt_16 d_iblock color-white hov-color"><?php the_title(); ?></a></h3>
                                    <p class="fs_16 lh_30 color-white mb_8"><?php echo wp_kses(vezaconslt_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                    <div class="link"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="p_relative d_iblock fs_14 fw_sbold theme-color pl_12"><i class="fa fa-angle-right"></i><?php esc_html_e('Read More', 'vezaconslt'); ?></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- coaching-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
