<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Agent_Details extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_our_agent_details';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Agent Details', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_agent_details',
            [
                'label' => esc_html__( 'Our Agent Details', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'phone_number',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'email_address',
            [
                'label'       => __( 'Email Address', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'address',
            [
                'label'       => __( 'Address', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'social_media',
            [
                'label'   => esc_html__( 'Social Media', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'vezaconslt'),
                            'type' => Controls_Manager::SELECT2,
							'label_block' => true,
                            'options' => get_fontawesome_icons(),
                        ],
						[
                            'name' => 'social_link',
							'label' => __( 'Social Link', 'vezaconslt' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com/', 'vezaconslt' ),
							'show_external' => true,
							'default' => [
								'url' => '',
								'is_external' => true,
								'nofollow' => true,
							],
						]
                    ],
            ]
        );
		$this->add_control(
            'skill_heading',
            [
                'label'       => __( 'Skill Heading', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'separator' => 'before',
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'skills',
            [
                'label'   => esc_html__( 'Skills', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'skill_name',
                            'label' => esc_html__('Skill Name', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'skill_value',
                            'label' => esc_html__('Skill Value', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                    ],
            ]
        );
		$this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Contact Form 7', 'vezaconslt'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- team-details -->
        <section class="team-details p_relative pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-12 col-sm-12 image-column">
                        <div class="image-box p_relative d_block mr_20">
                            <div class="image p_relative d_block b_radius_10 mb_25"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'vezaconslt'); ?>"></div>
                            <ul class="info clearfix">
                                <?php if ($settings['phone_number']){ ?>
                                <li class="p_relative d_block mb_2 fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Tel:', 'vezaconslt'); ?></span> <a href="tel:<?php echo esc_attr(phone_number($settings['phone_number'])); ?>" class="hov_color"><?php echo wp_kses( $settings['phone_number'], true ); ?></a></li>
                                <?php } ?>
                                
                                <?php if ($settings['email_address']){ ?>
                                <li class="p_relative d_block mb_2 fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Email:', 'vezaconslt'); ?></span> <a href="mailto:<?php echo sanitize_email( $settings['email_address'] ); ?>" class="hov_color"><?php echo sanitize_email( $settings['email_address'] ); ?></a></li>
                                <?php } ?>
                                
                                <?php if ($settings['address']){ ?>
                                <li class="p_relative d_block fs_18 lh_30"><span class="fw_medium"><?php esc_html_e('Add:', 'vezaconslt'); ?></span> <?php echo wp_kses( $settings['address'], true ); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-12 col-sm-12 content-column">
                        <div class="content-box p_relative d_block ml_20">
                            <div class="text p_relative d_block mb_60">
                                <h2 class="d_block fs_30 lh_40 fw_bold mb_3"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                <span class="designation p_relative d_block fs_15 lh_26 mb_25"><?php echo wp_kses( $settings['designation'], true ); ?></span>
                                <div class="text">
                                    <?php echo wp_kses( $settings['text'], true ); ?>
                                </div>
                            </div>
                            
                            <?php if ($settings['social_media']){ ?>
                            <!-- Social Box -->
                            <div class="social-box p_relative d_block mb_65">
                                <h3 class="fs_22 lh_30 fw_medium mb_12"><?php esc_html_e('Follow Me On:', 'vezaconslt'); ?></h3>
                                <ul class="social-links clearfix">
                                    <?php foreach($settings['social_media'] as $key => $item) { ?>
                                    <li class="p_relative d_iblock float_left mr_10"><a href="<?php echo esc_url( $item['social_link']['url'] ); ?>" class="d_block fs_14 b_radius_50 centred" target="_blank"><i class="fab <?php echo esc_attr(str_replace("fa ", "", $item['icon'])); ?>"></i></a></li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php } ?>
                            
                            <?php if ($settings['skills']){ ?>
                            <div class="skills-box p_relative d_block mb_65">
                                <h3 class="fs_22 lh_30 fw_bold mb_6"><?php echo wp_kses( $settings['skill_heading'], true ); ?></h3>
                                <div class="progress-inner p_relative d_block mb_40">
                                    <?php foreach($settings['skills'] as $key => $item) { ?>
                                    <div class="progress-box p_relative d_block mb_20">
                                        <h5 class="d_block fs_18 lh_30 fw_bold blue-color mb_5"><?php echo wp_kses( $item['skill_name'], true ); ?></h5>
                                        <div class="bar">
                                            <div class="bar-inner count-bar" data-percent="<?php echo esc_attr( $item['skill_value'] ); ?>%"></div>
                                            <div class="count-text p_absolute r_0 b_10 fs_14 fw_medium"><?php echo wp_kses( $item['skill_value'], true ); ?>%</div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['cf7_shortocde']){ ?>
                            <div class="form-inner">
                                <h3 class="fs_22 lh_30 fw_bold mb_35">Contact Me</h3>
                                <div class="default-form">
                                	<?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- team-details end -->
        
        <?php
    }
}
