<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Agents_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_our_agents_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Agents V2', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  2.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  2.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_agents_v2',
            [
                'label' => esc_html__( 'Our Agents V2', 'vezaconslt' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vezaconslt' ),
                    'title'      => esc_html__( 'Title', 'vezaconslt' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vezaconslt' ),
                    'rand'       => esc_html__( 'Random', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vezaconslt' ),
                    'ASC'  => esc_html__( 'ASC', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'vezaconslt'),
                'options' => get_categories_list('team_cat')
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = vezaconslt_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-vezaconslt' );
        $args = array(
            'post_type'      => 'team',
            'posts_per_page' => vezaconslt_set( $settings, 'query_number' ),
            'orderby'        => vezaconslt_set( $settings, 'query_orderby' ),
            'order'          => vezaconslt_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( vezaconslt_set( $settings, 'query_category' ) ) $args['team_cat'] = vezaconslt_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- team-page-section -->
        <section class="team-page-section p_relative pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <?php while($query->have_posts()) : $query->the_post(); ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 team-block">
                        <div class="team-block-one">
                            <div class="inner-box p_relative d_block centred">
                                <figure class="image-box p_relative d_block"><?php the_post_thumbnail('vezaconslt_370x470'); ?></figure>
                                <div class="lower-content p_relative d_block pt_25">
                                    <h3 class="d_block fs_22 lh_30"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="d_iblock black-color hov-color"><?php the_title(); ?></a></h3>
                                    <span class="designation d_block fs_16 fw_medium"><?php echo get_post_meta( get_the_id(), 'designation', true ); ?></span>
                                </div>
                                <div class="overlay-content bg-white b_shadow_6 z_1 pt_25 pb_30 pl_15 pr_15 tran_5">
                                    <h3 class="d_block fs_22 lh_30"><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true )); ?>" class="d_iblock black-color hov-color"><?php the_title(); ?></a></h3>
                                    <span class="designation d_block fs_16 fw_medium mb_18"><?php echo get_post_meta( get_the_id(), 'designation', true ); ?></span>
                                    
                                    <?php $icons = get_post_meta( get_the_id(), 'social_profile', true );
									if ( ! empty( $icons ) ) : ?>
                                    <ul class="social-links clearfix">
                                    	<?php foreach ( $icons as $h_icon ) :
										$header_social_icons = json_decode( urldecode( vezaconslt_set( $h_icon, 'data' ) ) );
										if ( vezaconslt_set( $header_social_icons, 'enable' ) == '' ) {
											continue;
										}
										$icon_class = explode( '-', vezaconslt_set( $header_social_icons, 'icon' ) ); ?>
										<li><a href="<?php echo vezaconslt_set( $header_social_icons, 'url' ); ?>" style="background-color:<?php echo vezaconslt_set( $header_social_icons, 'background' ); ?>; color: <?php echo vezaconslt_set( $header_social_icons, 'color' ); ?>" target="_blank"><i class="fab <?php echo esc_attr( vezaconslt_set( $header_social_icons, 'icon' ) ); ?>"></i></a></li>
										<?php endforeach; ?>
                                    </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- team-page-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
