<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Service_Details extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_service_details';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Service Details', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'service_details',
            [
                'label' => esc_html__( 'Service Details', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'bold_text',
            [
                'label'       => __( 'Bold Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'features',
            [
                'label'   => esc_html__( 'Features', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
						[
							'name' => 'icon',
							'label' => esc_html__('Select Icon', 'vezaconslt'),
							'type' => Controls_Manager::SELECT2,
							'label_block' => true,
							'options' => get_fontawesome_icons(),
						],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
		
		//Apply Visa
		$this->start_controls_section(
            'apply_visa_tab',
            [
                'label' => esc_html__( 'Apply Visa', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'title1',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text1',
            [
                'label'       => __( 'Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'image1',
            [
                'label' => __( 'Visa Benefits Image', 'vezaconslt' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'title2',
            [
                'label'       => __( 'Visa Benefits Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'features2',
            [
                'label'       => __( 'Visa Benefits Features', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'title3',
            [
                'label'       => __( 'Test Preparation Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text3',
            [
                'label'       => __( 'Test Preparation Text', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
		
		//Faqs Tabs
		$this->start_controls_section(
            'faqs_tab',
            [
                'label' => esc_html__( 'Faqs Tabs', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'title4',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'faqs',
            [
                'label'   => esc_html__( 'Faqs', 'vezaconslt' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'vezaconslt'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'vezaconslt'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
		
		//Sidebar
		$this->start_controls_section(
            'sidebar_tab',
            [
                'label' => esc_html__( 'Sidebar', 'vezaconslt' ),
            ]
        );
		$this->add_control(
			'sidebar',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'separate' => 'before',
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => vezaconslt_get_sidebars(),
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- service-details -->
        <div class="service-details">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
                        <div class="service-sidebar">
                            <?php dynamic_sidebar( $settings['sidebar'] ); ?>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                        <div class="service-details-content">
                            <div class="content-style-one">
                                <figure class="image-box featured-image"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                <div class="group-title">
                                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                </div>
                                <div class="text">
                                    <h3><?php echo wp_kses( $settings['bold_text'], true ); ?></h3>
                                    <p><?php echo wp_kses( $settings['text'], true ); ?></p>
                                </div>
                            </div>
                            <div class="content-style-two">
                                <div class="inner-box">
                                    <div class="row clearfix">
                                        <?php foreach($settings['features'] as $key => $item) { ?>
                                        <div class="col-lg-4 col-md-6 col-sm-12 column">
                                            <div class="single-item">
                                                <div class="icon-box"><i class="<?php echo esc_attr($item['icon']); ?>"></i></div>
                                                <h4><?php echo wp_kses( $item['title'], true ); ?></h4>
                                                <p><?php echo wp_kses( $item['text'], true ); ?></p>
                                            </div>
                                        </div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <h3><?php echo wp_kses( $settings['title1'], true ); ?></h3>
                                <div class="text">
                                    <p><?php echo wp_kses( $settings['text1'], true ); ?></p>
                                </div>
                            </div>
                            <div class="two-column">
                                <div class="row align-items-center clearfix">
                                    <div class="col-lg-6 col-md-6 col-sm-12 image-column">
                                        <figure class="image-box"><img src="<?php echo esc_url(wp_get_attachment_url($settings['image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'vezaconslt'); ?>"></figure>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-12 content-column">
                                        <div class="content-box">
                                            <h3><?php echo wp_kses( $settings['title2'], true ); ?></h3>
                                            
                                            <?php $features_list = $settings['features2'];
											if(!empty($features_list)){
											$features_list = explode("\n", ($features_list)); ?>
                                            <ul class="list clearfix">
                                            	<?php foreach($features_list as $features): ?>
                                                <li><?php echo wp_kses($features, true); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="text">
                                    <h3><?php echo wp_kses( $settings['title3'], true ); ?></h3>
                                    <p><?php echo wp_kses( $settings['text3'], true ); ?></p>
                                </div>
                            </div>
                            
                            <?php if($settings['faqs']){ ?>
                            <div class="accordion-content">
                                <h3><?php echo wp_kses( $settings['title4'], true ); ?></h3>
                                <ul class="accordion-box">
                                	<?php $i=1; foreach($settings['faqs'] as $key => $item) { ?>
                                    <li class="accordion block <?php if($i==1) echo 'active-block'; ?>">
                                        <div class="acc-btn <?php if($i==1) echo 'active'; ?>">
                                            <div class="icon-outer"></div>
                                            <h5><?php echo wp_kses( $item['title'], true ); ?></h5>
                                        </div>
                                        <div class="acc-content <?php if($i==1) echo 'current'; ?>">
                                            <p><?php echo wp_kses( $item['text'], true ); ?></p>
                                        </div>
                                    </li>
                                    <?php $i++; } ?>
                                </ul>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- service-details end -->
        
        <?php
    }
}
