<?php namespace VEZACONSLTPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Testimonials extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'vezaconslt_testimonials';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Testimonials', 'vezaconslt' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'vezaconslt' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'testimonials',
            [
                'label' => esc_html__( 'Testimonials', 'vezaconslt' ),
            ]
        );
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'vezaconslt' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 23,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'vezaconslt' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 9,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'vezaconslt' ),
                    'title'      => esc_html__( 'Title', 'vezaconslt' ),
                    'menu_order' => esc_html__( 'Menu Order', 'vezaconslt' ),
                    'rand'       => esc_html__( 'Random', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'vezaconslt' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'vezaconslt' ),
                    'ASC'  => esc_html__( 'ASC', 'vezaconslt' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'vezaconslt'),
                'options' => get_categories_list('testimonials_cat')
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = vezaconslt_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-vezaconslt' );
        $args = array(
            'post_type'      => 'testimonials',
            'posts_per_page' => vezaconslt_set( $settings, 'query_number' ),
            'orderby'        => vezaconslt_set( $settings, 'query_orderby' ),
            'order'          => vezaconslt_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( vezaconslt_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = vezaconslt_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- testimonial-section -->
        <section class="testimonial-section p_relative pt_110 pb_100 bg-color-2">
            <div class="pattern-layer p_absolute l_0 t_0" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/shape/shape-3.png'); ?>);"></div>
            <div class="auto-container">
                <div class="sec-title p_relative d_block mb_50 centred">
                    <span class="p_relative d_block fs_14 lh_20 fw_sbold theme-color mb_7"><?php echo wp_kses( $settings['subtitle'], true ); ?></span>
                    <h2 class="p_relative d_block lh_55 fw_exbold"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                <div class="three-item-carousel owl-carousel owl-theme owl-nav-none">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <div class="testimonial-block-one">
                        <div class="inner-box p_relative d_block bg-white pt_50 pr_40 pb_50 pl_50 b_radius_10">
                            <div class="quote"><span>“</span></div>
                            
                            <?php $rating = get_post_meta( get_the_id(), 'rating', true );
							if(!empty($rating)){ ?>
                            <ul class="rating clearfix p_relative d_block mb_15">
                            	<?php for ($x = 1; $x <= 5; $x++) {
								if($x <= $rating) echo '<li class="p_relative d_iblock pull-left fs_13 lh_20 mr_3"><i class="fa fa-star"></i></li>'; else echo '<li class="p_relative d_iblock pull-left fs_13 lh_20 mr_3"><i class="fa fa-star-o"></i></li>';
								} ?>
                            </ul>
                            <?php } ?>
                            <div class="text p_relative d_block mb_20">
                                <p><?php echo wp_kses(vezaconslt_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                            </div>
                            <div class="author-box p_relative d_block pl_100 pt_13 pb_14">
                                <figure class="author-thumb p_absolute l_0 t_0 b_radius_50"><?php the_post_thumbnail('vezaconslt_77x77'); ?></figure>
                                <h5 class="d_block fs_18 lh_30 theme-color"><?php the_title(); ?></h5>
                                <span class="designation d_block fs_14 lh_20 fw_medium"><?php echo get_post_meta( get_the_id(), 'designation', true ); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- testimonial-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
